/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

public final class TopologicalShapeSort {
    private final Map<ShapeId, Set<ShapeId>> forwardDependencies = new HashMap<ShapeId, Set<ShapeId>>();
    private final Queue<ShapeId> satisfiedShapes = new LinkedList<ShapeId>();

    public void enqueue(Shape shape) {
        this.enqueue(shape.getId(), shape.getMixins());
    }

    public void enqueue(ShapeId shape, Collection<ShapeId> dependencies) {
        this.forwardDependencies.put(shape, new LinkedHashSet<ShapeId>(dependencies));
    }

    public List<ShapeId> dequeueSortedShapes() {
        HashMap<ShapeId, Set<ShapeId>> reverseDependencies = new HashMap<ShapeId, Set<ShapeId>>();
        for (Map.Entry<ShapeId, Set<ShapeId>> entry : this.forwardDependencies.entrySet()) {
            if (entry.getValue().isEmpty()) {
                this.satisfiedShapes.offer(entry.getKey());
                continue;
            }
            for (ShapeId dependent : entry.getValue()) {
                reverseDependencies.computeIfAbsent(dependent, unused -> new HashSet()).add(entry.getKey());
            }
        }
        return this.topologicalSort(reverseDependencies);
    }

    private List<ShapeId> topologicalSort(Map<ShapeId, Set<ShapeId>> reverseDependencies) {
        ArrayList<ShapeId> result = new ArrayList<ShapeId>();
        while (!this.satisfiedShapes.isEmpty()) {
            ShapeId current = this.satisfiedShapes.poll();
            this.forwardDependencies.remove(current);
            result.add(current);
            for (ShapeId dependent : reverseDependencies.getOrDefault(current, Collections.emptySet())) {
                Set<ShapeId> dependentDependencies = this.forwardDependencies.get(dependent);
                dependentDependencies.remove(current);
                if (!dependentDependencies.isEmpty()) continue;
                this.satisfiedShapes.add(dependent);
            }
        }
        if (!this.forwardDependencies.isEmpty()) {
            throw new CycleException(new TreeSet<ShapeId>(this.forwardDependencies.keySet()));
        }
        return result;
    }

    public static final class CycleException
    extends RuntimeException {
        private final Set<ShapeId> unresolved;

        public CycleException(Set<ShapeId> unresolved) {
            super("Mixin cycles detected among " + unresolved);
            this.unresolved = unresolved;
        }

        public Set<ShapeId> getUnresolved() {
            return this.unresolved;
        }
    }
}

