/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

interface PendingShape {
    public static PendingShape create(ShapeId id, FromSourceLocation sourceLocation, Set<ShapeId> mixins, Consumer<Map<ShapeId, Shape>> creator) {
        return new Singular(id, sourceLocation, mixins, creator);
    }

    public static PendingConflict mergeIntoLeft(PendingShape left, PendingShape right) {
        if (!left.getId().equals(right.getId())) {
            throw new IllegalArgumentException("Cannot merge conflicting shapes with different IDs");
        }
        PendingConflict result = left instanceof PendingConflict ? (PendingConflict)left : new PendingConflict(left);
        result.pendingDelegates.add(right);
        result.pendingShapes.addAll(right.getPendingShapes());
        return result;
    }

    public ShapeId getId();

    public Set<ShapeId> getPendingShapes();

    public void buildShapes(Map<ShapeId, Shape> var1);

    public List<ValidationEvent> unresolved(Map<ShapeId, Shape> var1, Map<ShapeId, PendingShape> var2);

    public static class Singular
    implements PendingShape {
        private final ShapeId id;
        private final SourceLocation sourceLocation;
        private final Set<ShapeId> mixins;
        private final Set<ShapeId> pending;
        private final Consumer<Map<ShapeId, Shape>> creator;

        Singular(ShapeId id, FromSourceLocation sourceLocation, Set<ShapeId> mixins, Consumer<Map<ShapeId, Shape>> creator) {
            this.id = id;
            this.sourceLocation = sourceLocation.getSourceLocation();
            this.mixins = mixins;
            this.pending = new HashSet<ShapeId>(mixins);
            this.creator = creator;
        }

        @Override
        public ShapeId getId() {
            return this.id;
        }

        @Override
        public Set<ShapeId> getPendingShapes() {
            return this.pending;
        }

        @Override
        public void buildShapes(Map<ShapeId, Shape> shapeMap) {
            this.creator.accept(shapeMap);
        }

        @Override
        public List<ValidationEvent> unresolved(Map<ShapeId, Shape> resolved, Map<ShapeId, PendingShape> pending) {
            if (this.getPendingShapes().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ShapeId> nonMixinDependencies = new ArrayList<ShapeId>();
            ArrayList<ShapeId> notFoundShapes = new ArrayList<ShapeId>();
            ArrayList<ShapeId> missingTransitive = new ArrayList<ShapeId>();
            ArrayList<ShapeId> cycles = new ArrayList<ShapeId>();
            for (ShapeId id : this.getPendingShapes()) {
                if (resolved.containsKey(id)) {
                    nonMixinDependencies.add(id);
                    continue;
                }
                if (!pending.containsKey(id)) {
                    notFoundShapes.add(id);
                    continue;
                }
                if (this.anyMissingTransitiveDependencies(id, resolved, pending, new HashSet<ShapeId>())) {
                    missingTransitive.add(id);
                    continue;
                }
                cycles.add(id);
            }
            StringJoiner message = new StringJoiner(" ");
            message.add("Unable to resolve mixins;");
            if (!nonMixinDependencies.isEmpty()) {
                message.add("attempted to mixin shapes with no mixin trait: " + nonMixinDependencies);
            }
            if (!notFoundShapes.isEmpty()) {
                message.add("attempted to mixin shapes that are not in the model: " + notFoundShapes);
            }
            if (!missingTransitive.isEmpty()) {
                message.add("unable to resolve due to missing transitive mixins: " + missingTransitive);
            }
            if (!cycles.isEmpty()) {
                message.add("cycles detected between this shape and " + cycles);
            }
            return Collections.singletonList(ValidationEvent.builder().id("Model").severity(Severity.ERROR).shapeId(this.getId()).sourceLocation(this.sourceLocation).message(message.toString()).build());
        }

        private boolean anyMissingTransitiveDependencies(ShapeId current, Map<ShapeId, Shape> resolved, Map<ShapeId, PendingShape> otherPending, Set<ShapeId> visited) {
            if (resolved.containsKey(current)) {
                return false;
            }
            if (!otherPending.containsKey(current)) {
                return true;
            }
            if (visited.contains(current)) {
                visited.remove(current);
                return false;
            }
            visited.add(current);
            for (ShapeId next : otherPending.get(current).getPendingShapes()) {
                if (!this.anyMissingTransitiveDependencies(next, resolved, otherPending, visited)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PendingConflict
    implements PendingShape {
        private final List<PendingShape> pendingDelegates = new ArrayList<PendingShape>();
        private final Set<ShapeId> pendingShapes;

        PendingConflict(PendingShape pending) {
            this.pendingDelegates.add(pending);
            this.pendingShapes = new HashSet<ShapeId>(pending.getPendingShapes());
        }

        @Override
        public ShapeId getId() {
            return this.pendingDelegates.get(0).getId();
        }

        @Override
        public Set<ShapeId> getPendingShapes() {
            return this.pendingShapes;
        }

        @Override
        public void buildShapes(Map<ShapeId, Shape> shapeMap) {
            for (PendingShape p : this.pendingDelegates) {
                p.buildShapes(shapeMap);
            }
        }

        @Override
        public List<ValidationEvent> unresolved(Map<ShapeId, Shape> resolved, Map<ShapeId, PendingShape> pending) {
            ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
            for (PendingShape p : this.pendingDelegates) {
                events.addAll(p.unresolved(resolved, pending));
            }
            return events;
        }
    }
}

