/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.MetadataContainer;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.PendingShape;
import software.amazon.smithy.model.loader.TopologicalShapeSort;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidationEvent;

final class CompositeModelFile
implements ModelFile {
    private static final Logger LOGGER = Logger.getLogger(CompositeModelFile.class.getName());
    private final TraitFactory traitFactory;
    private final List<ModelFile> modelFiles;
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();

    CompositeModelFile(TraitFactory traitFactory, List<ModelFile> modelFiles) {
        this.traitFactory = traitFactory;
        this.modelFiles = modelFiles;
    }

    @Override
    public Version getVersion() {
        return Version.UNKNOWN;
    }

    @Override
    public String getFilename() {
        return SourceLocation.none().getFilename();
    }

    @Override
    public Set<ShapeId> shapeIds() {
        HashSet<ShapeId> ids = new HashSet<ShapeId>();
        for (ModelFile modelFile : this.modelFiles) {
            ids.addAll(modelFile.shapeIds());
        }
        return ids;
    }

    @Override
    public ShapeType getShapeType(ShapeId id) {
        for (ModelFile modFile : this.modelFiles) {
            ShapeType fileType = modFile.getShapeType(id);
            if (fileType == null) continue;
            return fileType;
        }
        return null;
    }

    @Override
    public Map<String, Node> metadata() {
        MetadataContainer metadata = new MetadataContainer(this.events);
        for (ModelFile modelFile : this.modelFiles) {
            for (Map.Entry<String, Node> entry : modelFile.metadata().entrySet()) {
                metadata.putMetadata(entry.getKey(), entry.getValue());
            }
        }
        return metadata.getData();
    }

    @Override
    public TraitContainer resolveShapes(Set<ShapeId> ids, Function<ShapeId, ShapeType> typeProvider) {
        TraitContainer.TraitHashMap traitValues = new TraitContainer.TraitHashMap(this.traitFactory, this.events);
        for (ModelFile modelFile : this.modelFiles) {
            TraitContainer other = modelFile.resolveShapes(ids, typeProvider);
            for (Map.Entry<ShapeId, Map<ShapeId, Trait>> entry : other.traits().entrySet()) {
                ShapeId target = entry.getKey();
                for (Map.Entry<ShapeId, Trait> appliedEntry : entry.getValue().entrySet()) {
                    traitValues.onTrait(target, appliedEntry.getValue());
                }
            }
        }
        return traitValues;
    }

    @Override
    public List<ValidationEvent> events() {
        int size = this.events.size();
        for (ModelFile modelFile : this.modelFiles) {
            size += modelFile.events().size();
        }
        ArrayList<ValidationEvent> newEvents = new ArrayList<ValidationEvent>(size);
        newEvents.addAll(this.events);
        for (ModelFile modelFile : this.modelFiles) {
            newEvents.addAll(modelFile.events());
        }
        return newEvents;
    }

    @Override
    public ModelFile.CreatedShapes createShapes(TraitContainer resolvedTraits) {
        ResolvedShapeMap createdShapes = new ResolvedShapeMap();
        PendingShapeMap pendingShapes = new PendingShapeMap();
        TopologicalShapeSort sorter = new TopologicalShapeSort();
        for (ModelFile modelFile : this.modelFiles) {
            ModelFile.CreatedShapes created = modelFile.createShapes(resolvedTraits);
            for (Shape shape : created.getCreatedShapes()) {
                createdShapes.put(shape.getId(), shape);
                if (!shape.hasTrait(MixinTrait.class)) continue;
                sorter.enqueue(shape);
            }
            for (PendingShape pending : created.getPendingShapes()) {
                sorter.enqueue(pending.getId(), pending.getPendingShapes());
                pendingShapes.put(pending.getId(), pending);
            }
        }
        try {
            for (ShapeId id : sorter.dequeueSortedShapes()) {
                if (!pendingShapes.containsKey(id)) continue;
                ((PendingShape)pendingShapes.get(id)).buildShapes(createdShapes);
            }
        }
        catch (TopologicalShapeSort.CycleException e) {
            for (PendingShape pending : pendingShapes.values()) {
                if (!e.getUnresolved().contains(pending.getId())) continue;
                this.events.addAll(pending.unresolved(createdShapes, pendingShapes));
                resolvedTraits.getTraitsForShape(pending.getId()).clear();
            }
        }
        return new ModelFile.CreatedShapes(createdShapes.values(), Collections.emptyList());
    }

    private final class ResolvedShapeMap
    extends HashMap<ShapeId, Shape> {
        private ResolvedShapeMap() {
        }

        @Override
        public Shape put(ShapeId key, Shape value) {
            Shape old = (Shape)this.get(key);
            if (old == null) {
                return super.put(key, value);
            }
            if (!old.equals(value)) {
                CompositeModelFile.this.events.add(LoaderUtils.onShapeConflict(key, value.getSourceLocation(), old.getSourceLocation()));
            } else if (!LoaderUtils.isSameLocation(value, old)) {
                LOGGER.warning(() -> "Ignoring duplicate but equivalent shape definition: " + old.getId() + " defined at " + value.getSourceLocation() + " and " + old.getSourceLocation());
            }
            return old;
        }
    }

    private static final class PendingShapeMap
    extends HashMap<ShapeId, PendingShape> {
        private PendingShapeMap() {
        }

        @Override
        public PendingShape put(ShapeId key, PendingShape pending) {
            PendingShape old = (PendingShape)this.get(key);
            if (old != null) {
                pending = PendingShape.mergeIntoLeft(old, pending);
            }
            return super.put(key, pending);
        }
    }
}

