/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.MetadataContainer;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.PendingShape;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

abstract class AbstractMutableModelFile
implements ModelFile {
    protected TraitContainer.VersionAwareTraitContainer traitContainer;
    private final String filename;
    private final Set<ShapeId> allShapeIds = new HashSet<ShapeId>();
    private final Map<ShapeId, AbstractShapeBuilder<?, ?>> shapes = new LinkedHashMap();
    private final Map<ShapeId, Map<String, MemberShape.Builder>> members = new HashMap<ShapeId, Map<String, MemberShape.Builder>>();
    private final Map<ShapeId, Set<ShapeId>> pendingShapes = new HashMap<ShapeId, Set<ShapeId>>();
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();
    private final MetadataContainer metadata = new MetadataContainer(this.events);
    private final TraitFactory traitFactory;

    AbstractMutableModelFile(String filename, TraitFactory traitFactory) {
        this.filename = filename;
        this.traitFactory = Objects.requireNonNull(traitFactory, "traitFactory must not be null");
        TraitContainer.TraitHashMap traitStore = new TraitContainer.TraitHashMap(traitFactory, this.events);
        this.traitContainer = new TraitContainer.VersionAwareTraitContainer(traitStore);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public final Version getVersion() {
        return this.traitContainer.getVersion();
    }

    void onShape(AbstractShapeBuilder<?, ?> builder) {
        this.allShapeIds.add(builder.getId());
        if (!this.getVersion().isShapeTypeSupported(builder.getShapeType())) {
            throw new SourceException(String.format("%s shapes may only be used with Smithy version 2 or later.", builder.getShapeType().toString()), builder.getSourceLocation());
        }
        if (builder instanceof MemberShape.Builder) {
            String memberName = builder.getId().getMember().get();
            ShapeId containerId = builder.getId().withoutMember();
            if (!this.members.containsKey(containerId)) {
                this.members.put(containerId, new LinkedHashMap());
            } else if (this.members.get(containerId).containsKey(memberName)) {
                throw this.onConflict(builder, this.members.get(containerId).get(memberName));
            }
            this.members.get(containerId).put(memberName, (MemberShape.Builder)builder);
        } else {
            if (this.shapes.containsKey(builder.getId())) {
                throw this.onConflict(builder, this.shapes.get(builder.getId()));
            }
            this.shapes.put(builder.getId(), builder);
        }
    }

    void addPendingMixin(ShapeId shape, ShapeId mixin) {
        this.pendingShapes.computeIfAbsent(shape, id -> new LinkedHashSet()).add(mixin);
    }

    private SourceException onConflict(AbstractShapeBuilder<?, ?> builder, AbstractShapeBuilder<?, ?> previous) {
        ValidationEvent event = LoaderUtils.onShapeConflict(builder.getId(), builder.getSourceLocation(), previous.getSourceLocation());
        return new SourceException(event.getMessage(), event.getSourceLocation());
    }

    final void putMetadata(String key, Node value) {
        this.metadata.putMetadata(key, value);
    }

    final void onTrait(ShapeId target, ShapeId trait, Node value) {
        this.traitContainer.onTrait(target, trait, value);
    }

    final void onTrait(ShapeId target, Trait trait) {
        this.traitContainer.onTrait(target, trait);
    }

    final void setVersion(Version version) {
        this.traitContainer.setVersion(version);
    }

    @Override
    public final List<ValidationEvent> events() {
        return this.events;
    }

    @Override
    public final Map<String, Node> metadata() {
        return this.metadata.getData();
    }

    @Override
    public final Set<ShapeId> shapeIds() {
        return this.allShapeIds;
    }

    @Override
    public final ShapeType getShapeType(ShapeId id) {
        return this.shapes.containsKey(id) ? this.shapes.get(id).getShapeType() : null;
    }

    @Override
    public final ModelFile.CreatedShapes createShapes(TraitContainer resolvedTraits) {
        ArrayList<Shape> resolvedShapes = new ArrayList<Shape>(this.shapes.size());
        ArrayList<PendingShape> pendingMixins = new ArrayList<PendingShape>();
        for (Map.Entry<ShapeId, Set<ShapeId>> entry : this.pendingShapes.entrySet()) {
            ShapeId subject = entry.getKey();
            Set<ShapeId> mixins = entry.getValue();
            AbstractShapeBuilder<?, ?> builder = this.shapes.get(entry.getKey());
            Map<String, MemberShape.Builder> builderMembers = this.claimMembersOfContainer(builder.getId());
            this.shapes.remove(entry.getKey());
            pendingMixins.add(this.createPendingShape(subject, builder, builderMembers, mixins, this.traitContainer));
        }
        for (Map map : this.members.values()) {
            for (MemberShape.Builder builder : map.values()) {
                ShapeId id = builder.getId();
                AbstractShapeBuilder<?, ?> container = this.shapes.get(id.withoutMember());
                if (container == null) {
                    throw new RuntimeException("Container shape not found for member: " + id);
                }
                for (Trait trait : resolvedTraits.getTraitsForShape(id).values()) {
                    builder.addTrait(trait);
                }
                container.addMember(builder.build());
            }
        }
        for (AbstractShapeBuilder abstractShapeBuilder : this.shapes.values()) {
            this.buildShape(abstractShapeBuilder, resolvedTraits).ifPresent(resolvedShapes::add);
        }
        return new ModelFile.CreatedShapes(resolvedShapes, pendingMixins);
    }

    private Map<String, MemberShape.Builder> claimMembersOfContainer(ShapeId id) {
        Map<String, MemberShape.Builder> result = this.members.remove(id);
        return result == null ? Collections.emptyMap() : result;
    }

    private PendingShape createPendingShape(ShapeId subject, AbstractShapeBuilder<?, ?> builder, Map<String, MemberShape.Builder> builderMembers, Set<ShapeId> mixins, TraitContainer resolvedTraits) {
        return PendingShape.create(subject, builder, mixins, shapeMap -> {
            for (MemberShape.Builder memberBuilder : builderMembers.values()) {
                this.buildShape(memberBuilder, resolvedTraits).ifPresent(builder::addMember);
            }
            for (ShapeId mixin : mixins) {
                Shape mixinShape = (Shape)shapeMap.get(mixin);
                for (MemberShape member : mixinShape.members()) {
                    ShapeId targetId = builder.getId().withMember(member.getMemberName());
                    Map<ShapeId, Trait> introducedTraits = this.traitContainer.getTraitsForShape(targetId);
                    MemberShape introducedMember = null;
                    if (builderMembers.containsKey(member.getMemberName())) {
                        introducedMember = ((MemberShape.Builder)((MemberShape.Builder)builderMembers.get(member.getMemberName())).addMixin(member)).build();
                        if (!introducedMember.getTarget().equals(member.getTarget())) {
                            MemberShape.Builder conflict = (MemberShape.Builder)builderMembers.get(member.getMemberName());
                            this.events.add(ValidationEvent.builder().severity(Severity.ERROR).id("Model").shapeId(conflict.getId()).sourceLocation(conflict.getSourceLocation()).message("Member conflicts with an inherited mixin member: " + member.getId()).build());
                        }
                    } else if (!introducedTraits.isEmpty()) {
                        introducedMember = ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(targetId)).target(member.getTarget()).source(member.getSourceLocation())).addTraits(introducedTraits.values())).addMixin(member)).build();
                    }
                    if (introducedMember == null) continue;
                    builder.addMember(introducedMember);
                }
                builder.addMixin(mixinShape);
            }
            this.buildShape(builder, resolvedTraits).ifPresent(result -> shapeMap.put(result.getId(), result));
        });
    }

    private <S extends Shape, B extends AbstractShapeBuilder<? extends B, S>> Optional<S> buildShape(B builder, TraitContainer resolvedTraits) {
        try {
            for (Trait trait : resolvedTraits.getTraitsForShape(builder.getId()).values()) {
                builder.addTrait(trait);
            }
            return Optional.of((Shape)builder.build());
        }
        catch (SourceException e) {
            this.events.add(ValidationEvent.fromSourceException(e, "", builder.getId()));
            resolvedTraits.clearTraitsForShape(builder.getId());
            return Optional.empty();
        }
    }
}

