/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Objects;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.SparseTrait;

public class NullableIndex
implements KnowledgeIndex {
    private final WeakReference<Model> model;

    public NullableIndex(Model model) {
        this.model = new WeakReference<Model>(model);
    }

    public static NullableIndex of(Model model) {
        return model.getKnowledge(NullableIndex.class, NullableIndex::new);
    }

    public final boolean isNullable(ToShapeId shape) {
        Model m = Objects.requireNonNull((Model)this.model.get());
        Shape s = m.expectShape(shape.toShapeId());
        MemberShape member = s.asMemberShape().orElse(null);
        return member == null || this.isMemberOptional(member);
    }

    public boolean isMemberOptional(MemberShape member) {
        Model m = Objects.requireNonNull((Model)this.model.get());
        Shape container = m.expectShape(member.getContainer());
        switch (container.getType()) {
            case STRUCTURE: {
                return !member.hasTrait(DefaultTrait.class) && !member.hasTrait(RequiredTrait.class);
            }
            case UNION: 
            case SET: {
                return false;
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }
}

