/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class SensitiveTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : model.getMemberShapesWithTrait(SensitiveTrait.class)) {
            SensitiveTrait trait = member.expectTrait(SensitiveTrait.class);
            events.add(this.warning(member, trait, "Instead of marking members with the `sensitive` trait, a better approach is to instead mark the targeted shape as sensitive. This helps to prevent modeling mistakes by ensuring every reference to data types that are inherently sensitive are always considered sensitive. Types that are conditionally sensitive should generally be separated into two types: one to represent a sensitive type and one to represent the normal type. Applying `sensitive` trait to members is considered deprecated. It will be removed in Smithy IDL version 2.0."));
        }
        return events;
    }
}

