/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class HttpResponseCodeSemanticsValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapesWithTrait(HttpTrait.class)) {
            this.validateOperationsWithHttpTrait(operation).ifPresent(events::add);
        }
        for (StructureShape structure : model.getStructureShapesWithTrait(ErrorTrait.class)) {
            this.validateError(structure, structure.expectTrait(ErrorTrait.class)).ifPresent(events::add);
        }
        return events;
    }

    private Optional<ValidationEvent> validateOperationsWithHttpTrait(OperationShape operation) {
        HttpTrait trait = operation.expectTrait(HttpTrait.class);
        if (trait.getCode() < 200 || trait.getCode() >= 300) {
            return Optional.of(this.invalidOperation(operation, trait));
        }
        return Optional.empty();
    }

    private ValidationEvent invalidOperation(Shape shape, HttpTrait trait) {
        return this.danger(shape, trait, "Expected an `http` code in the 2xx range, but found " + trait.getCode());
    }

    private Optional<ValidationEvent> validateError(StructureShape shape, ErrorTrait error) {
        return shape.getTrait(HttpErrorTrait.class).flatMap(httpErrorTrait -> {
            int code = httpErrorTrait.getCode();
            if (error.isClientError() && (code < 400 || code >= 500)) {
                return Optional.of(this.invalidError(shape, (Trait)httpErrorTrait, code, "4xx", error.getValue()));
            }
            if (error.isServerError() && (code < 500 || code >= 600)) {
                return Optional.of(this.invalidError(shape, (Trait)httpErrorTrait, code, "5xx", error.getValue()));
            }
            return Optional.empty();
        });
    }

    private ValidationEvent invalidError(Shape shape, Trait trait, int code, String range, String errorValue) {
        return this.danger(shape, trait, String.format("Expected an `httpError` code in the %s range for a `%s` error, but found %s", range, errorValue, code));
    }
}

