/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.model.loader.AbstractMutableModelFile;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;

final class FullyResolvedModelFile
extends AbstractMutableModelFile {
    FullyResolvedModelFile(TraitFactory traitFactory) {
        super(traitFactory);
    }

    static FullyResolvedModelFile fromShapes(TraitFactory traitFactory, Collection<Shape> shapes) {
        FullyResolvedModelFile modelFile = new FullyResolvedModelFile(traitFactory);
        for (Shape shape : shapes) {
            Object builder = ((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).clearTraits();
            modelFile.onShape((AbstractShapeBuilder<?, ?>)builder);
            for (Trait trait : shape.getAllTraits().values()) {
                modelFile.onTrait(shape.getId(), trait);
            }
        }
        return modelFile;
    }

    @Override
    public TraitContainer resolveShapes(Set<ShapeId> shapeIds, Function<ShapeId, ShapeType> typeProvider) {
        return this.traitContainer;
    }
}

