/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.math.BigDecimal;
import java.util.Optional;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RangeTrait
extends AbstractTrait
implements ToSmithyBuilder<RangeTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#range");
    private final BigDecimal min;
    private final BigDecimal max;

    private RangeTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.min = builder.min;
        this.max = builder.max;
        if (this.max == null && this.min == null) {
            throw new SourceException("One of 'min' or 'max' must be provided.", this.getSourceLocation());
        }
    }

    public Optional<BigDecimal> getMin() {
        return Optional.ofNullable(this.min);
    }

    public Optional<BigDecimal> getMax() {
        return Optional.ofNullable(this.max);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("min", this.getMin().map(Node::from)).withOptionalMember("max", this.getMax().map(Node::from));
    }

    public Builder toBuilder() {
        return (Builder)RangeTrait.builder().min(this.min).max(this.max).sourceLocation(this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<RangeTrait, Builder> {
        private BigDecimal min;
        private BigDecimal max;

        public Builder min(BigDecimal min) {
            this.min = min;
            return this;
        }

        public Builder max(BigDecimal max) {
            this.max = max;
            return this;
        }

        public RangeTrait build() {
            return new RangeTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public RangeTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            BigDecimal minValue = objectNode.getMember("min").map(node -> new BigDecimal(node.expectNumberNode().getValue().toString())).orElse(null);
            BigDecimal maxValue = objectNode.getMember("max").map(node -> new BigDecimal(node.expectNumberNode().getValue().toString())).orElse(null);
            RangeTrait result = ((Builder)RangeTrait.builder().sourceLocation(value)).min(minValue).max(maxValue).build();
            result.setNodeCache(value);
            return result;
        }
    }
}

