/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.ValidationLoader;
import software.amazon.smithy.model.loader.ValidatorDefinition;
import software.amazon.smithy.model.loader.ValidatorFromDefinitionFactory;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.traits.SuppressTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.model.validation.suppressions.Suppression;
import software.amazon.smithy.model.validation.validators.ResourceCycleValidator;
import software.amazon.smithy.model.validation.validators.TargetValidator;
import software.amazon.smithy.utils.SetUtils;

final class ModelValidator {
    private static final String SUPPRESSIONS = "suppressions";
    private static final Set<Class<? extends Validator>> CORE_VALIDATORS = SetUtils.of((Object[])new Class[]{TargetValidator.class, ResourceCycleValidator.class});
    private final List<Validator> validators = new ArrayList<Validator>();
    private final List<Suppression> suppressions = new ArrayList<Suppression>();
    private final List<ValidationEvent> includeEvents = new ArrayList<ValidationEvent>();
    private ValidatorFactory validatorFactory;
    private Consumer<ValidationEvent> eventListener;

    ModelValidator() {
    }

    public ModelValidator validators(Collection<? extends Validator> validators) {
        this.validators.clear();
        validators.forEach(this::addValidator);
        return this;
    }

    public ModelValidator addValidator(Validator validator) {
        this.validators.add(Objects.requireNonNull(validator));
        return this;
    }

    public ModelValidator suppressions(Collection<? extends Suppression> suppressions) {
        this.suppressions.clear();
        suppressions.forEach(this::addSuppression);
        return this;
    }

    public ModelValidator addSuppression(Suppression suppression) {
        this.suppressions.add(Objects.requireNonNull(suppression));
        return this;
    }

    public ModelValidator validatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
        return this;
    }

    public ModelValidator eventListener(Consumer<ValidationEvent> eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public ModelValidator includeEvents(List<ValidationEvent> events) {
        this.includeEvents.clear();
        this.includeEvents.addAll(events);
        return this;
    }

    public Validator createValidator() {
        if (this.validatorFactory == null) {
            this.validatorFactory = LazyValidatorFactoryHolder.INSTANCE;
        }
        List<Validator> staticValidators = this.resolveStaticValidators();
        return model -> {
            ArrayList<ValidationEvent> coreEvents = new ArrayList<ValidationEvent>();
            ArrayList<Suppression> modelSuppressions = new ArrayList<Suppression>(this.suppressions);
            ModelValidator.loadModelSuppressions(modelSuppressions, model);
            ArrayList<Validator> modelValidators = new ArrayList<Validator>(staticValidators);
            ModelValidator.loadModelValidators(this.validatorFactory, modelValidators, model, coreEvents, modelSuppressions);
            coreEvents.addAll(new TargetValidator().validate(model));
            coreEvents.addAll(new ResourceCycleValidator().validate(model));
            coreEvents.forEach(this.eventListener);
            if (LoaderUtils.containsErrorEvents(coreEvents)) {
                return coreEvents;
            }
            Stream eventStream = Stream.concat(this.includeEvents.stream(), modelValidators.parallelStream().flatMap(validator -> validator.validate(model).stream()));
            List result = eventStream.filter(ModelValidator::filterPrelude).map(event -> ModelValidator.suppressEvent(model, event, modelSuppressions)).peek(this.eventListener).collect(Collectors.toList());
            result.addAll(coreEvents);
            return result;
        };
    }

    private List<Validator> resolveStaticValidators() {
        ArrayList<Validator> resolvedValidators = new ArrayList<Validator>(this.validatorFactory.loadBuiltinValidators());
        resolvedValidators.addAll(this.validators);
        resolvedValidators.removeIf(v -> CORE_VALIDATORS.contains(v.getClass()));
        return resolvedValidators;
    }

    private static boolean filterPrelude(ValidationEvent event) {
        return event.getSeverity() == Severity.ERROR || !event.getShapeId().filter(Prelude::isPreludeShape).isPresent();
    }

    private static void loadModelValidators(ValidatorFactory validatorFactory, List<Validator> validators, Model model, List<ValidationEvent> events, List<Suppression> suppressions) {
        ValidatedResult<List<ValidatorDefinition>> loaded = ValidationLoader.loadValidators(model.getMetadata());
        events.addAll(loaded.getValidationEvents());
        List definitions = loaded.getResult().orElseGet(Collections::emptyList);
        ValidatorFromDefinitionFactory factory = new ValidatorFromDefinitionFactory(validatorFactory);
        for (ValidatorDefinition val : definitions) {
            ValidatedResult<Validator> result = factory.loadValidator(val);
            result.getResult().ifPresent(validators::add);
            events.addAll(result.getValidationEvents());
            if (!result.getValidationEvents().isEmpty() || result.getResult().isPresent()) continue;
            ValidationEvent event = ModelValidator.unknownValidatorError(val.name, val.sourceLocation);
            events.add(ModelValidator.suppressEvent(model, event, suppressions));
        }
    }

    private static ValidationEvent unknownValidatorError(String name, SourceLocation location) {
        return ValidationEvent.builder().id("UnknownValidator_" + name).severity(Severity.WARNING).sourceLocation(location).message("Unable to locate a validator named `" + name + "`").build();
    }

    private static void loadModelSuppressions(List<Suppression> suppressions, Model model) {
        model.getMetadataProperty(SUPPRESSIONS).ifPresent(value -> {
            List<ObjectNode> values = value.expectArrayNode().getElementsAs(ObjectNode.class);
            for (ObjectNode rule : values) {
                suppressions.add(Suppression.fromMetadata(rule));
            }
        });
    }

    private static ValidationEvent suppressEvent(Model model, ValidationEvent event, List<Suppression> suppressions) {
        if (!event.getSeverity().canSuppress()) {
            return event;
        }
        Suppression matchedSuppression = ModelValidator.findMatchingSuppression(model, event, suppressions);
        if (matchedSuppression == null) {
            return event;
        }
        ValidationEvent.Builder builder = event.toBuilder();
        builder.severity(Severity.SUPPRESSED);
        matchedSuppression.getReason().ifPresent(builder::suppressionReason);
        return builder.build();
    }

    private static Suppression findMatchingSuppression(Model model, ValidationEvent event, List<Suppression> suppressions) {
        return event.getShapeId().flatMap(model::getShape).flatMap(shape -> shape.hasTrait(SuppressTrait.class) ? Optional.of(Suppression.fromSuppressTrait(shape)) : Optional.empty()).flatMap(suppression -> suppression.test(event) ? Optional.of(suppression) : Optional.empty()).orElseGet(() -> {
            for (Suppression suppression : suppressions) {
                if (!suppression.test(event)) continue;
                return suppression;
            }
            return null;
        });
    }

    private static final class LazyValidatorFactoryHolder {
        static final ValidatorFactory INSTANCE = ValidatorFactory.createServiceFactory(ModelAssembler.class.getClassLoader());

        private LazyValidatorFactoryHolder() {
        }
    }
}

