/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.math.BigDecimal;
import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

class RangeTraitPlugin
implements NodeValidatorPlugin {
    RangeTraitPlugin() {
    }

    @Override
    public final void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
        if (shape.hasTrait(RangeTrait.class)) {
            if (value.isNumberNode()) {
                this.check(shape, shape.expectTrait(RangeTrait.class), value.expectNumberNode(), emitter);
            } else if (value.isStringNode()) {
                this.checkNonNumeric(shape, shape.expectTrait(RangeTrait.class), value.expectStringNode(), emitter);
            }
        }
    }

    private void checkNonNumeric(Shape shape, RangeTrait trait, StringNode node, BiConsumer<FromSourceLocation, String> emitter) {
        Node.NonNumericFloat.fromStringRepresentation(node.getValue()).ifPresent(value -> {
            if (value.equals((Object)Node.NonNumericFloat.NAN)) {
                emitter.accept(node, String.format("Value provided for `%s` must be a number because the `smithy.api#range` trait is applied, but found \"%s\"", shape.getId(), node.getValue()));
            }
            if (trait.getMin().isPresent() && value.equals((Object)Node.NonNumericFloat.NEGATIVE_INFINITY)) {
                emitter.accept(node, String.format("Value provided for `%s` must be greater than or equal to %s, but found \"%s\"", shape.getId(), trait.getMin().get(), node.getValue()));
            }
            if (trait.getMax().isPresent() && value.equals((Object)Node.NonNumericFloat.POSITIVE_INFINITY)) {
                emitter.accept(node, String.format("Value provided for `%s` must be less than or equal to %s, but found \"%s\"", shape.getId(), trait.getMax().get(), node.getValue()));
            }
        });
    }

    protected void check(Shape shape, RangeTrait trait, NumberNode node, BiConsumer<FromSourceLocation, String> emitter) {
        Number number = node.getValue();
        BigDecimal decimal = new BigDecimal(number.toString());
        trait.getMin().ifPresent(min -> {
            if (decimal.compareTo(new BigDecimal(min.toString())) < 0) {
                emitter.accept(node, String.format("Value provided for `%s` must be greater than or equal to %s, but found %s", shape.getId(), min.toString(), number));
            }
        });
        trait.getMax().ifPresent(max -> {
            if (decimal.compareTo(new BigDecimal(max.toString())) > 0) {
                emitter.accept(node, String.format("Value provided for `%s` must be less than or equal to %s, but found %s", shape.getId(), max.toString(), number));
            }
        });
    }
}

