/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelFile;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ImmutablePreludeModelFile
implements ModelFile {
    private final Model prelude;
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();

    ImmutablePreludeModelFile(Model prelude) {
        this.prelude = prelude;
    }

    @Override
    public Set<ShapeId> shapeIds() {
        return this.prelude.getShapeIds();
    }

    @Override
    public Map<String, Node> metadata() {
        return this.prelude.getMetadata();
    }

    @Override
    public TraitContainer resolveShapes(Set<ShapeId> ids, Function<ShapeId, ShapeType> typeProvider) {
        return TraitContainer.EMPTY;
    }

    @Override
    public Collection<Shape> createShapes(TraitContainer resolvedTraits) {
        Map<ShapeId, Map<ShapeId, Trait>> invalidTraits = resolvedTraits.getTraitsAppliedToPrelude();
        for (Map.Entry<ShapeId, Map<ShapeId, Trait>> entry : invalidTraits.entrySet()) {
            for (Map.Entry<ShapeId, Trait> trait : entry.getValue().entrySet()) {
                String message = String.format("Cannot apply `%s` to an immutable prelude shape defined in `smithy.api`.", trait.getKey());
                this.events.add(ValidationEvent.builder().severity(Severity.ERROR).id("Model").sourceLocation(trait.getValue().getSourceLocation()).shapeId((ToShapeId)entry.getKey()).message(message).build());
            }
        }
        return this.prelude.toSet();
    }

    @Override
    public List<ValidationEvent> events() {
        return this.events;
    }

    @Override
    public ShapeType getShapeType(ShapeId id) {
        return this.prelude.getShape(id).map(Shape::getType).orElse(null);
    }
}

