/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.StringUtils;

public final class ModelSerializer {
    private final Predicate<String> metadataFilter;
    private final Predicate<Shape> shapeFilter;
    private final Predicate<Trait> traitFilter;
    private final ShapeSerializer shapeSerializer = new ShapeSerializer();

    private ModelSerializer(Builder builder) {
        this.metadataFilter = builder.metadataFilter;
        this.shapeFilter = !builder.includePrelude ? builder.shapeFilter.and(FunctionalUtils.not(Prelude::isPreludeShape)) : builder.shapeFilter;
        this.traitFilter = builder.traitFilter;
    }

    public ObjectNode serialize(Model model) {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("smithy", Node.from("1.0")).withOptionalMember("metadata", this.createMetadata(model).map(Node::withDeepSortedKeys));
        ObjectNode.Builder shapesBuilder = Node.objectNodeBuilder();
        model.shapes().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(this.shapeFilter).map(shape -> Pair.of((Object)shape, (Object)shape.accept(this.shapeSerializer))).sorted(Comparator.comparing(pair -> ((Shape)pair.getLeft()).getId().getName())).forEach(pair -> shapesBuilder.withMember(((Shape)pair.getLeft()).getId().toString(), (ToNode)pair.getRight()));
        builder.withMember("shapes", shapesBuilder.build());
        return builder.build();
    }

    private Optional<Node> createMetadata(Model model) {
        Map<StringNode, Node> metadata = model.getMetadata().entrySet().stream().filter(entry -> this.metadataFilter.test((String)entry.getKey())).collect(Collectors.toMap(entry -> Node.from((String)entry.getKey()), Map.Entry::getValue));
        return metadata.isEmpty() ? Optional.empty() : Optional.of(new ObjectNode(metadata, SourceLocation.NONE));
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class ShapeSerializer
    extends ShapeVisitor.Default<Node> {
        private ShapeSerializer() {
        }

        private ObjectNode.Builder createTypedNode(Shape shape) {
            return Node.objectNodeBuilder().withMember("type", Node.from(shape.getType().toString()));
        }

        private ObjectNode.Builder withTraits(Shape shape, ObjectNode.Builder shapeBuilder) {
            if (shape.getAllTraits().isEmpty()) {
                return shapeBuilder;
            }
            ObjectNode.Builder traitBuilder = Node.objectNodeBuilder();
            shape.getAllTraits().values().stream().filter(ModelSerializer.this.traitFilter).sorted(Comparator.comparing(Trait::toShapeId)).forEach(trait -> traitBuilder.withMember(trait.toShapeId().toString(), trait.toNode()));
            return shapeBuilder.withMember("traits", traitBuilder.build());
        }

        @Override
        protected ObjectNode getDefault(Shape shape) {
            return this.withTraits(shape, this.createTypedNode(shape)).build();
        }

        @Override
        public Node listShape(ListShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("member", (ToNode)shape.getMember().accept(this))).build();
        }

        @Override
        public Node setShape(SetShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("member", (ToNode)shape.getMember().accept(this))).build();
        }

        @Override
        public Node mapShape(MapShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withMember("key", (ToNode)shape.getKey().accept(this)).withMember("value", (ToNode)shape.getValue().accept(this))).build();
        }

        @Override
        public Node operationShape(OperationShape shape) {
            return this.withTraits(shape, this.createTypedNode(shape).withOptionalMember("input", shape.getInput().map(this::serializeReference)).withOptionalMember("output", shape.getOutput().map(this::serializeReference)).withOptionalMember("errors", this.createOptionalIdList(shape.getErrors()))).build();
        }

        @Override
        public Node resourceShape(ResourceShape shape) {
            Optional<Object> identifiers = Optional.empty();
            if (shape.hasIdentifiers()) {
                Stream ids = shape.getIdentifiers().entrySet().stream();
                identifiers = Optional.of(ids.collect(ObjectNode.collectStringKeys(Map.Entry::getKey, entry -> this.serializeReference((ShapeId)entry.getValue()))));
            }
            return this.withTraits(shape, this.createTypedNode(shape).withOptionalMember("identifiers", identifiers).withOptionalMember("put", shape.getPut().map(this::serializeReference)).withOptionalMember("create", shape.getCreate().map(this::serializeReference)).withOptionalMember("read", shape.getRead().map(this::serializeReference)).withOptionalMember("update", shape.getUpdate().map(this::serializeReference)).withOptionalMember("delete", shape.getDelete().map(this::serializeReference)).withOptionalMember("list", shape.getList().map(this::serializeReference)).withOptionalMember("operations", this.createOptionalIdList(shape.getOperations())).withOptionalMember("collectionOperations", this.createOptionalIdList(shape.getCollectionOperations())).withOptionalMember("resources", this.createOptionalIdList(shape.getResources()))).build();
        }

        @Override
        public Node serviceShape(ServiceShape shape) {
            ObjectNode.Builder serviceBuilder = this.withTraits(shape, this.createTypedNode(shape));
            if (!StringUtils.isBlank((CharSequence)shape.getVersion())) {
                serviceBuilder.withMember("version", Node.from(shape.getVersion()));
            }
            serviceBuilder.withOptionalMember("operations", this.createOptionalIdList(shape.getOperations()));
            serviceBuilder.withOptionalMember("resources", this.createOptionalIdList(shape.getResources()));
            serviceBuilder.withOptionalMember("errors", this.createOptionalIdList(shape.getErrors()));
            if (!shape.getRename().isEmpty()) {
                ObjectNode.Builder renameBuilder = Node.objectNodeBuilder();
                for (Map.Entry<ShapeId, String> entry : shape.getRename().entrySet()) {
                    renameBuilder.withMember(entry.getKey().toString(), entry.getValue());
                }
                serviceBuilder.withMember("rename", renameBuilder.build());
            }
            return serviceBuilder.build();
        }

        private Optional<Node> createOptionalIdList(Collection<ShapeId> list) {
            if (list.isEmpty()) {
                return Optional.empty();
            }
            Node result = list.stream().sorted().map(this::serializeReference).collect(ArrayNode.collect());
            return Optional.of(result);
        }

        @Override
        public Node structureShape(StructureShape shape) {
            return this.createStructureAndUnion(shape, shape.getAllMembers());
        }

        @Override
        public Node unionShape(UnionShape shape) {
            return this.createStructureAndUnion(shape, shape.getAllMembers());
        }

        private ObjectNode createStructureAndUnion(Shape shape, Map<String, MemberShape> members) {
            ObjectNode.Builder builder = this.createTypedNode(shape);
            ObjectNode.Builder memberBuilder = ObjectNode.objectNodeBuilder();
            for (MemberShape member : members.values()) {
                Node memberValue = member.accept(this);
                memberBuilder.withMember(member.getMemberName(), memberValue);
            }
            builder.withMember("members", memberBuilder.build());
            this.withTraits(shape, builder);
            return builder.build();
        }

        @Override
        public Node memberShape(MemberShape shape) {
            ObjectNode.Builder builder = this.serializeReference(shape.getTarget()).toBuilder();
            this.withTraits(shape, builder);
            return builder.build();
        }

        private ObjectNode serializeReference(ShapeId id) {
            return Node.objectNode().withMember("target", id.toString());
        }
    }

    public static final class Builder
    implements SmithyBuilder<ModelSerializer> {
        private Predicate<String> metadataFilter = FunctionalUtils.alwaysTrue();
        private Predicate<Shape> shapeFilter = FunctionalUtils.alwaysTrue();
        private boolean includePrelude = false;
        private Predicate<Trait> traitFilter = FunctionalUtils.alwaysTrue();

        private Builder() {
        }

        public Builder metadataFilter(Predicate<String> metadataFilter) {
            this.metadataFilter = Objects.requireNonNull(metadataFilter);
            return this;
        }

        public Builder shapeFilter(Predicate<Shape> shapeFilter) {
            this.shapeFilter = Objects.requireNonNull(shapeFilter);
            return this;
        }

        public Builder includePrelude(boolean includePrelude) {
            this.includePrelude = includePrelude;
            return this;
        }

        public Builder traitFilter(Predicate<Trait> traitFilter) {
            this.traitFilter = traitFilter;
            return this;
        }

        public ModelSerializer build() {
            return new ModelSerializer(this);
        }
    }
}

