/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class MetadataContainer {
    private static final Logger LOGGER = Logger.getLogger(MetadataContainer.class.getName());
    private final Map<String, Node> data = new LinkedHashMap<String, Node>();
    private final List<ValidationEvent> events;

    MetadataContainer(List<ValidationEvent> events) {
        this.events = events;
    }

    void putMetadata(String key, Node value) {
        Node previous = this.data.putIfAbsent(key, value);
        if (previous == null) {
            return;
        }
        if (LoaderUtils.isSameLocation(value, previous) && value.equals(previous)) {
            LOGGER.finer(() -> "Ignoring duplicate metadata key from same exact location: " + key);
        } else if (previous.isArrayNode() && value.isArrayNode()) {
            ArrayNode previousArray = previous.expectArrayNode();
            ArrayList<Node> merged = new ArrayList<Node>(previousArray.getElements());
            merged.addAll(value.expectArrayNode().getElements());
            this.data.put(key, new ArrayNode(merged, value.getSourceLocation()));
        } else if (!previous.equals(value)) {
            this.events.add(ValidationEvent.builder().id("Model").severity(Severity.ERROR).sourceLocation(value).message(String.format("Metadata conflict for key `%s`. Defined in both `%s` and `%s`", key, value.getSourceLocation(), previous.getSourceLocation())).build());
        } else {
            LOGGER.fine(() -> "Ignoring duplicate metadata definition of " + key);
        }
    }

    Map<String, Node> getData() {
        return this.data;
    }
}

