/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.XmlNamespaceTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class XmlNamespaceTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(XmlNamespaceTrait.class)) {
            this.validateTrait(shape, shape.expectTrait(XmlNamespaceTrait.class)).ifPresent(events::add);
        }
        return events;
    }

    private Optional<ValidationEvent> validateTrait(Shape shape, XmlNamespaceTrait xmlNamespace) {
        try {
            new URI(xmlNamespace.getUri());
        }
        catch (URISyntaxException uriSyntaxException) {
            return Optional.of(this.error(shape, String.format("An `xmlNamespace` trait is applied to the %s shape with an invalid uri: %s", shape, xmlNamespace.getUri())));
        }
        return Optional.empty();
    }
}

