/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.UnreferencedShapes;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class UnreferencedShapeValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        long serviceShapes = model.shapes(ServiceShape.class).count();
        if (serviceShapes == 0L) {
            return Collections.emptyList();
        }
        return new UnreferencedShapes().compute(model).stream().map(shape -> this.note((Shape)shape, String.format("The %s shape is not connected to from any service shape.", new Object[]{shape.getType()}))).collect(Collectors.toList());
    }
}

