/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class AbstractShapeBuilder<B extends AbstractShapeBuilder<?, ?>, S extends Shape>
implements SmithyBuilder<S>,
FromSourceLocation {
    private ShapeId id;
    private Map<ShapeId, Trait> traits;
    private SourceLocation source = SourceLocation.none();

    AbstractShapeBuilder() {
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.source;
    }

    public abstract ShapeType getShapeType();

    public ShapeId getId() {
        return this.id;
    }

    public B id(ShapeId shapeId) {
        this.id = shapeId;
        return (B)this;
    }

    public final B id(String shapeId) {
        return this.id(ShapeId.from(shapeId));
    }

    public final B source(SourceLocation sourceLocation) {
        if (sourceLocation == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = sourceLocation;
        return (B)this;
    }

    public final B source(String filename, int line, int column) {
        return this.source(new SourceLocation(filename, line, column));
    }

    public final B traits(Collection<Trait> traitsToSet) {
        this.clearTraits();
        traitsToSet.forEach(this::addTrait);
        return (B)this;
    }

    public final B addTraits(Collection<Trait> traitsToAdd) {
        traitsToAdd.forEach(this::addTrait);
        return (B)this;
    }

    public final B addTrait(Trait trait) {
        if (trait == null) {
            throw new IllegalArgumentException("trait must not be null");
        }
        if (this.traits == null) {
            this.traits = new HashMap<ShapeId, Trait>();
        }
        this.traits.put(trait.toShapeId(), trait);
        return (B)this;
    }

    public final B removeTrait(String traitId) {
        return this.removeTrait(ShapeId.from(Trait.makeAbsoluteName(traitId)));
    }

    public final B removeTrait(ShapeId traitId) {
        if (this.traits != null) {
            this.traits.remove(traitId);
        }
        return (B)this;
    }

    public final B clearTraits() {
        if (this.traits != null) {
            this.traits.clear();
        }
        return (B)this;
    }

    final B from(S shape) {
        return ((AbstractShapeBuilder)((AbstractShapeBuilder)this.id(((Shape)shape).getId())).source(((Shape)shape).getSourceLocation())).addTraits(((Shape)shape).getAllTraits().values());
    }

    public B addMember(MemberShape member) {
        throw new UnsupportedOperationException(String.format("Member `%s` cannot be added to %s", member.getId(), this.getClass().getName()));
    }

    Map<ShapeId, Trait> copyTraits() {
        return this.traits == null ? Collections.emptyMap() : MapUtils.copyOf(this.traits);
    }
}

