/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ProtocolDefinitionTrait
extends AbstractTrait
implements ToSmithyBuilder<ProtocolDefinitionTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#protocolDefinition");
    private static final String NO_INLINE_DOCUMENT_SUPPORT = "noInlineDocumentSupport";
    private static final String TRAITS = "traits";
    private final List<ShapeId> traits;
    private final boolean noInlineDocumentSupport;

    public ProtocolDefinitionTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.traits = ListUtils.copyOf((Collection)builder.traits);
        this.noInlineDocumentSupport = builder.noInlineDocumentSupport;
    }

    public List<ShapeId> getTraits() {
        return this.traits;
    }

    public boolean getNoInlineDocumentSupport() {
        return this.noInlineDocumentSupport;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.sourceLocation(this.getSourceLocation());
        if (!this.traits.isEmpty()) {
            ArrayNode ids = this.traits.stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect());
            builder.withMember(TRAITS, ids);
            if (this.noInlineDocumentSupport) {
                builder.withMember(NO_INLINE_DOCUMENT_SUPPORT, true);
            }
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return ((Builder)ProtocolDefinitionTrait.builder().sourceLocation(this.getSourceLocation())).traits(this.traits).noInlineDocumentSupport(this.noInlineDocumentSupport);
    }

    public static final class Builder
    extends AbstractTraitBuilder<ProtocolDefinitionTrait, Builder> {
        private final List<ShapeId> traits = new ArrayList<ShapeId>();
        private boolean noInlineDocumentSupport;

        public ProtocolDefinitionTrait build() {
            return new ProtocolDefinitionTrait(this);
        }

        public Builder traits(List<ShapeId> traits) {
            this.traits.clear();
            this.traits.addAll(traits);
            return this;
        }

        public Builder addTrait(ShapeId trait) {
            this.traits.add(trait);
            return this;
        }

        public Builder noInlineDocumentSupport(boolean noInlineDocumentSupport) {
            this.noInlineDocumentSupport = noInlineDocumentSupport;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public ProtocolDefinitionTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)ProtocolDefinitionTrait.builder().sourceLocation(value);
            ObjectNode objectNode = value.expectObjectNode();
            objectNode.getArrayMember(ProtocolDefinitionTrait.TRAITS).ifPresent(traits -> {
                for (String string : Node.loadArrayOfString(ProtocolDefinitionTrait.TRAITS, traits)) {
                    builder.addTrait(ShapeId.from(string));
                }
            });
            builder.noInlineDocumentSupport(objectNode.getBooleanMemberOrDefault(ProtocolDefinitionTrait.NO_INLINE_DOCUMENT_SUPPORT));
            return builder.build();
        }
    }
}

