/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ExamplesTrait
extends AbstractTrait
implements ToSmithyBuilder<ExamplesTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#examples");
    private final List<Example> examples;

    private ExamplesTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.examples = new ArrayList<Example>(builder.examples);
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    @Override
    protected Node createNode() {
        return this.examples.stream().map(Example::toNode).collect(ArrayNode.collect(this.getSourceLocation()));
    }

    public Builder toBuilder() {
        Builder builder = (Builder)new Builder().sourceLocation(this.getSourceLocation());
        this.examples.forEach(builder::addExample);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public ExamplesTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)ExamplesTrait.builder().sourceLocation(value);
            value.expectArrayNode().getElements().stream().map(Node::expectObjectNode).map(Provider::exampleFromNode).forEach(builder::addExample);
            return builder.build();
        }

        private static Example exampleFromNode(ObjectNode node) {
            Example.Builder builder = Example.builder().title(node.expectStringMember("title").getValue()).documentation(node.getStringMember("documentation").map(StringNode::getValue).orElse(null)).input(node.getMember("input").map(Node::expectObjectNode).orElseGet(Node::objectNode)).output(node.getMember("output").map(Node::expectObjectNode).orElseGet(Node::objectNode));
            node.getObjectMember("error").map(ErrorExample::fromNode).map(builder::error);
            return builder.build();
        }
    }

    public static final class ErrorExample
    implements ToNode,
    ToSmithyBuilder<ErrorExample> {
        private final ShapeId shapeId;
        private final ObjectNode content;

        public ErrorExample(Builder builder) {
            this.shapeId = builder.shapeId;
            this.content = builder.content;
        }

        public static ErrorExample fromNode(ObjectNode node) {
            return ErrorExample.builder().shapeId(node.expectStringMember("shapeId").expectShapeId()).content(node.expectObjectMember("content")).build();
        }

        public ShapeId getShapeId() {
            return this.shapeId;
        }

        public ObjectNode getContent() {
            return this.content;
        }

        @Override
        public Node toNode() {
            return ObjectNode.objectNodeBuilder().withMember("shapeId", this.shapeId.toString()).withMember("content", this.content).build();
        }

        public SmithyBuilder<ErrorExample> toBuilder() {
            return ErrorExample.builder().content(this.content).shapeId(this.shapeId);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements SmithyBuilder<ErrorExample> {
            private ShapeId shapeId;
            private ObjectNode content = Node.objectNode();

            public ErrorExample build() {
                return new ErrorExample(this);
            }

            public Builder shapeId(ShapeId shapeId) {
                this.shapeId = shapeId;
                return this;
            }

            public Builder content(ObjectNode content) {
                this.content = content;
                return this;
            }
        }
    }

    public static final class Example
    implements ToNode,
    ToSmithyBuilder<Example> {
        private final String title;
        private final String documentation;
        private final ObjectNode input;
        private final ObjectNode output;
        private final ErrorExample error;

        private Example(Builder builder) {
            this.title = Objects.requireNonNull(builder.title, "Example title must not be null");
            this.documentation = builder.documentation;
            this.input = builder.input;
            this.output = builder.output;
            this.error = builder.error;
        }

        public String getTitle() {
            return this.title;
        }

        public Optional<String> getDocumentation() {
            return Optional.ofNullable(this.documentation);
        }

        public ObjectNode getInput() {
            return this.input;
        }

        public ObjectNode getOutput() {
            return this.output;
        }

        public Optional<ErrorExample> getError() {
            return Optional.ofNullable(this.error);
        }

        @Override
        public Node toNode() {
            ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("title", Node.from(this.title)).withOptionalMember("documentation", this.getDocumentation().map(Node::from)).withOptionalMember("error", this.getError().map(ErrorExample::toNode));
            if (!this.input.isEmpty()) {
                builder.withMember("input", this.input);
            }
            if (!this.output.isEmpty()) {
                builder.withMember("output", this.output);
            }
            return builder.build();
        }

        public Builder toBuilder() {
            return new Builder().documentation(this.documentation).title(this.title).input(this.input).output(this.output).error(this.error);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements SmithyBuilder<Example> {
            private String title;
            private String documentation;
            private ObjectNode input = Node.objectNode();
            private ObjectNode output = Node.objectNode();
            private ErrorExample error;

            public Example build() {
                return new Example(this);
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder documentation(String documentation) {
                this.documentation = documentation;
                return this;
            }

            public Builder input(ObjectNode input) {
                this.input = input;
                return this;
            }

            public Builder output(ObjectNode output) {
                this.output = output;
                return this;
            }

            public Builder error(ErrorExample error) {
                this.error = error;
                return this;
            }
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<ExamplesTrait, Builder> {
        private final List<Example> examples = new ArrayList<Example>();

        public Builder addExample(Example example) {
            this.examples.add(Objects.requireNonNull(example));
            return this;
        }

        public Builder clearExamples() {
            this.examples.clear();
            return this;
        }

        public ExamplesTrait build() {
            return new ExamplesTrait(this);
        }
    }
}

