/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpChecksumProperty
implements ToNode,
ToSmithyBuilder<HttpChecksumProperty> {
    private static final String ALGORITHM = "algorithm";
    private static final String LOCATION = "in";
    private static final String NAME = "name";
    private static final Set<String> KEYS = SetUtils.of((Object[])new String[]{"algorithm", "in", "name"});
    private final String algorithm;
    private final Location location;
    private final String name;

    private HttpChecksumProperty(Builder builder) {
        this.algorithm = Objects.requireNonNull(builder.algorithm);
        this.location = Objects.requireNonNull(builder.location);
        this.name = Objects.requireNonNull(builder.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HttpChecksumProperty fromNode(Node node) {
        ObjectNode value = node.expectObjectNode().warnIfAdditionalProperties(KEYS);
        Builder builder = HttpChecksumProperty.builder();
        value.getStringMember(ALGORITHM).map(StringNode::getValue).ifPresent(builder::algorithm);
        value.getStringMember(LOCATION).map(StringNode::getValue).ifPresent(builder::location);
        value.getStringMember(NAME).map(StringNode::getValue).ifPresent(builder::name);
        return builder.build();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public SmithyBuilder<HttpChecksumProperty> toBuilder() {
        return HttpChecksumProperty.builder().algorithm(this.getAlgorithm()).location(this.getLocation()).name(this.getName());
    }

    @Override
    public Node toNode() {
        return Node.objectNodeBuilder().withMember(ALGORITHM, this.getAlgorithm()).withMember(LOCATION, this.getLocation().toNode()).withMember(NAME, this.getName()).build();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.location, this.algorithm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpChecksumProperty)) {
            return false;
        }
        HttpChecksumProperty that = (HttpChecksumProperty)o;
        return this.algorithm.equals(that.algorithm) && this.location.equals(that.location) && this.name.equals(that.name);
    }

    public boolean conflictsWith(HttpChecksumProperty otherProperty) {
        return this.algorithm.equals(otherProperty.algorithm) && this.location.equals(otherProperty.location);
    }

    public static final class Builder
    implements SmithyBuilder<HttpChecksumProperty> {
        private String name;
        private String algorithm;
        private Location location;

        public HttpChecksumProperty build() {
            return new HttpChecksumProperty(this);
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm.toLowerCase(Locale.ENGLISH);
            return this;
        }

        public Builder name(String name) {
            this.name = name.toLowerCase(Locale.ENGLISH);
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder location(String location) {
            this.location = Location.fromString(location);
            return this;
        }
    }

    public static enum Location implements ToNode
    {
        HEADER("header"),
        TRAILER("trailer");

        private final String serialized;

        private Location(String serialized) {
            this.serialized = serialized;
        }

        public static Location fromNode(Node node) {
            String value = node.expectStringNode().expectOneOf("header", "trailer").toUpperCase(Locale.ENGLISH);
            return Location.valueOf(value);
        }

        public static Location fromString(String value) {
            if (value == null) {
                throw new NullPointerException("Found null string argument when converting to Location type");
            }
            value = value.toLowerCase(Locale.ENGLISH);
            for (Location location : Location.values()) {
                if (!location.serialized.equals(value)) continue;
                return location;
            }
            throw new IllegalArgumentException("Invalid location type: " + value);
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public Node toNode() {
            return Node.from(this.toString());
        }
    }
}

