/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class OperationShape
extends Shape
implements ToSmithyBuilder<OperationShape> {
    private final ShapeId input;
    private final ShapeId output;
    private final List<ShapeId> errors;

    private OperationShape(Builder builder) {
        super(builder, false);
        this.errors = ListUtils.copyOf((Collection)builder.errors);
        this.input = builder.input;
        this.output = builder.output;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)OperationShape.builder().from(this)).input(this.input).output(this.output).errors(this.errors);
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.operationShape(this);
    }

    @Override
    public Optional<OperationShape> asOperationShape() {
        return Optional.of(this);
    }

    public Optional<ShapeId> getInput() {
        return Optional.ofNullable(this.input);
    }

    public Optional<ShapeId> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public List<ShapeId> getErrors() {
        return this.errors;
    }

    public List<ShapeId> getErrors(ServiceShape service) {
        LinkedHashSet<ShapeId> result = new LinkedHashSet<ShapeId>(service.getErrors());
        result.addAll(this.getErrors());
        return new ArrayList<ShapeId>(result);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        OperationShape otherShape = (OperationShape)other;
        return Objects.equals(this.input, otherShape.input) && Objects.equals(this.output, otherShape.output) && this.errors.equals(otherShape.errors);
    }

    public static final class Builder
    extends AbstractShapeBuilder<Builder, OperationShape> {
        private ShapeId input;
        private ShapeId output;
        private final List<ShapeId> errors = new ArrayList<ShapeId>();

        @Override
        public ShapeType getShapeType() {
            return ShapeType.OPERATION;
        }

        public Builder input(ToShapeId inputShape) {
            this.input = inputShape == null ? null : inputShape.toShapeId();
            return this;
        }

        public Builder output(ToShapeId outputShape) {
            this.output = outputShape == null ? null : outputShape.toShapeId();
            return this;
        }

        public Builder errors(Collection<ShapeId> errorShapeIds) {
            this.errors.clear();
            errorShapeIds.forEach(this::addError);
            return this;
        }

        public Builder addError(ToShapeId errorShapeId) {
            this.errors.add(errorShapeId.toShapeId());
            return this;
        }

        public Builder addError(String errorShapeId) {
            return this.addError(ShapeId.from(errorShapeId));
        }

        public Builder addErrors(Collection<ShapeId> errorShapeIds) {
            this.errors.addAll(Objects.requireNonNull(errorShapeIds));
            return this;
        }

        public Builder removeError(ToShapeId errorShapeId) {
            this.errors.remove(errorShapeId.toShapeId());
            return this;
        }

        public Builder clearErrors() {
            this.errors.clear();
            return this;
        }

        public OperationShape build() {
            return new OperationShape(this);
        }
    }
}

