/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import software.amazon.smithy.model.ShapeTypeFilteredSet;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Model
implements ToSmithyBuilder<Model> {
    public static final String MODEL_VERSION = "1.0";
    private final Map<String, Node> metadata;
    private final Map<ShapeId, Shape> shapeMap;
    private final Map<Class<? extends Shape>, Set<? extends Shape>> cachedTypes = new ConcurrentHashMap<Class<? extends Shape>, Set<? extends Shape>>();
    private final Map<Class<? extends KnowledgeIndex>, KnowledgeIndex> blackboard = Collections.synchronizedMap(new IdentityHashMap());
    private volatile TraitCache traitCache;
    private int hash;

    private Model(Builder builder) {
        this.shapeMap = MapUtils.copyOf((Map)builder.shapeMap);
        this.metadata = builder.metadata.isEmpty() ? MapUtils.of() : MapUtils.copyOf((Map)builder.metadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelAssembler assembler() {
        return new ModelAssembler();
    }

    public static ModelAssembler assembler(ClassLoader classLoader) {
        return new ModelAssembler().traitFactory(TraitFactory.createServiceFactory(classLoader)).validatorFactory(ValidatorFactory.createServiceFactory(classLoader));
    }

    public Optional<Node> getMetadataProperty(String name) {
        return Optional.ofNullable(this.metadata.get(name));
    }

    public Map<String, Node> getMetadata() {
        return this.metadata;
    }

    public Optional<TraitDefinition> getTraitDefinition(ToShapeId traitId) {
        return this.getShape(traitId.toShapeId()).flatMap(shape -> shape.getTrait(TraitDefinition.class));
    }

    public Set<Shape> getShapesWithTrait(ToShapeId trait) {
        Map mappings = this.getTraitCache().traitIdsToShapes;
        return Collections.unmodifiableSet(mappings.getOrDefault(trait.toShapeId(), Collections.emptySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraitCache getTraitCache() {
        TraitCache cache = this.traitCache;
        if (cache == null) {
            Model model = this;
            synchronized (model) {
                cache = this.traitCache;
                if (cache == null) {
                    this.traitCache = cache = new TraitCache(this.shapeMap.values());
                }
            }
        }
        return cache;
    }

    public Set<ShapeId> getShapeIds() {
        return this.shapeMap.keySet();
    }

    public Set<Shape> getShapesWithTrait(Class<? extends Trait> trait) {
        Map mappings = this.getTraitCache().traitsToShapes;
        return Collections.unmodifiableSet(mappings.getOrDefault(trait, Collections.emptySet()));
    }

    public Set<BigDecimalShape> getBigDecimalShapes() {
        return this.toSet(BigDecimalShape.class);
    }

    public Set<BigDecimalShape> getBigDecimalShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<BigDecimalShape>(this.getShapesWithTrait(trait), BigDecimalShape.class);
    }

    public Set<BigIntegerShape> getBigIntegerShapes() {
        return this.toSet(BigIntegerShape.class);
    }

    public Set<BigIntegerShape> getBigIntegerShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<BigIntegerShape>(this.getShapesWithTrait(trait), BigIntegerShape.class);
    }

    public Set<BlobShape> getBlobShapes() {
        return this.toSet(BlobShape.class);
    }

    public Set<BlobShape> getBlobShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<BlobShape>(this.getShapesWithTrait(trait), BlobShape.class);
    }

    public Set<BooleanShape> getBooleanShapes() {
        return this.toSet(BooleanShape.class);
    }

    public Set<BooleanShape> getBooleanShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<BooleanShape>(this.getShapesWithTrait(trait), BooleanShape.class);
    }

    public Set<ByteShape> getByteShapes() {
        return this.toSet(ByteShape.class);
    }

    public Set<ByteShape> getByteShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<ByteShape>(this.getShapesWithTrait(trait), ByteShape.class);
    }

    public Set<DocumentShape> getDocumentShapes() {
        return this.toSet(DocumentShape.class);
    }

    public Set<DocumentShape> getDocumentShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<DocumentShape>(this.getShapesWithTrait(trait), DocumentShape.class);
    }

    public Set<DoubleShape> getDoubleShapes() {
        return this.toSet(DoubleShape.class);
    }

    public Set<DoubleShape> getDoubleShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<DoubleShape>(this.getShapesWithTrait(trait), DoubleShape.class);
    }

    public Set<FloatShape> getFloatShapes() {
        return this.toSet(FloatShape.class);
    }

    public Set<FloatShape> getFloatShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<FloatShape>(this.getShapesWithTrait(trait), FloatShape.class);
    }

    public Set<IntegerShape> getIntegerShapes() {
        return this.toSet(IntegerShape.class);
    }

    public Set<IntegerShape> getIntegerShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<IntegerShape>(this.getShapesWithTrait(trait), IntegerShape.class);
    }

    public Set<ListShape> getListShapes() {
        return this.toSet(ListShape.class);
    }

    public Set<ListShape> getListShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<ListShape>(this.getShapesWithTrait(trait), ListShape.class);
    }

    public Set<LongShape> getLongShapes() {
        return this.toSet(LongShape.class);
    }

    public Set<LongShape> getLongShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<LongShape>(this.getShapesWithTrait(trait), LongShape.class);
    }

    public Set<MapShape> getMapShapes() {
        return this.toSet(MapShape.class);
    }

    public Set<MapShape> getMapShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<MapShape>(this.getShapesWithTrait(trait), MapShape.class);
    }

    public Set<MemberShape> getMemberShapes() {
        return this.toSet(MemberShape.class);
    }

    public Set<MemberShape> getMemberShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<MemberShape>(this.getShapesWithTrait(trait), MemberShape.class);
    }

    public Set<OperationShape> getOperationShapes() {
        return this.toSet(OperationShape.class);
    }

    public Set<OperationShape> getOperationShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<OperationShape>(this.getShapesWithTrait(trait), OperationShape.class);
    }

    public Set<ResourceShape> getResourceShapes() {
        return this.toSet(ResourceShape.class);
    }

    public Set<ResourceShape> getResourceShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<ResourceShape>(this.getShapesWithTrait(trait), ResourceShape.class);
    }

    public Set<ServiceShape> getServiceShapes() {
        return this.toSet(ServiceShape.class);
    }

    public Set<ServiceShape> getServiceShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<ServiceShape>(this.getShapesWithTrait(trait), ServiceShape.class);
    }

    public Set<SetShape> getSetShapes() {
        return this.toSet(SetShape.class);
    }

    public Set<SetShape> getSetShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<SetShape>(this.getShapesWithTrait(trait), SetShape.class);
    }

    public Set<ShortShape> getShortShapes() {
        return this.toSet(ShortShape.class);
    }

    public Set<ShortShape> getShortShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<ShortShape>(this.getShapesWithTrait(trait), ShortShape.class);
    }

    public Set<StringShape> getStringShapes() {
        return this.toSet(StringShape.class);
    }

    public Set<StringShape> getStringShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<StringShape>(this.getShapesWithTrait(trait), StringShape.class);
    }

    public Set<StructureShape> getStructureShapes() {
        return this.toSet(StructureShape.class);
    }

    public Set<StructureShape> getStructureShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<StructureShape>(this.getShapesWithTrait(trait), StructureShape.class);
    }

    public Set<TimestampShape> getTimestampShapes() {
        return this.toSet(TimestampShape.class);
    }

    public Set<TimestampShape> getTimestampShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<TimestampShape>(this.getShapesWithTrait(trait), TimestampShape.class);
    }

    public Set<UnionShape> getUnionShapes() {
        return this.toSet(UnionShape.class);
    }

    public Set<UnionShape> getUnionShapesWithTrait(Class<? extends Trait> trait) {
        return new ShapeTypeFilteredSet<UnionShape>(this.getShapesWithTrait(trait), UnionShape.class);
    }

    public Set<ShapeId> getAppliedTraits() {
        return Collections.unmodifiableSet(this.getTraitCache().traitIdsToShapes.keySet());
    }

    public boolean isTraitApplied(Class<? extends Trait> trait) {
        return !this.getShapesWithTrait(trait).isEmpty();
    }

    public Optional<Shape> getShape(ShapeId id) {
        return Optional.ofNullable(this.shapeMap.get(id));
    }

    public Shape expectShape(ShapeId id) {
        return this.getShape(id).orElseThrow(() -> new ExpectationNotMetException("Shape not found in model: " + id, SourceLocation.NONE));
    }

    public <T extends Shape> T expectShape(ShapeId id, Class<T> type) {
        Shape shape = this.expectShape(id);
        if (type.isInstance(shape)) {
            return (T)shape;
        }
        throw new ExpectationNotMetException(String.format("Expected shape `%s` to be an instance of `%s`, but found `%s`", new Object[]{id, type.getSimpleName(), shape.getType()}), shape);
    }

    public Stream<Shape> shapes() {
        return this.shapeMap.values().stream();
    }

    public <T extends Shape> Stream<T> shapes(Class<T> shapeType) {
        return this.toSet(shapeType).stream();
    }

    public <T extends Shape> Set<T> toSet(Class<T> shapeType) {
        return this.cachedTypes.computeIfAbsent(shapeType, t -> {
            HashSet<Shape> result = new HashSet<Shape>();
            for (Shape shape : this.shapeMap.values()) {
                if (shape.getClass() != shapeType) continue;
                result.add(shape);
            }
            return Collections.unmodifiableSet(result);
        });
    }

    public Set<Shape> toSet() {
        return new AbstractSet<Shape>(){

            @Override
            public int size() {
                return Model.this.shapeMap.size();
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof Shape && Model.this.shapeMap.containsKey(((Shape)o).getId());
            }

            @Override
            public Iterator<Shape> iterator() {
                return Model.this.shapeMap.values().iterator();
            }
        };
    }

    public boolean equals(Object other) {
        if (!(other instanceof Model)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Model otherModel = (Model)other;
        return this.getMetadata().equals(otherModel.getMetadata()) && this.shapeMap.equals(otherModel.shapeMap);
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = Objects.hash(this.getMetadata(), this.shapeMap.keySet());
        }
        return result;
    }

    public Builder toBuilder() {
        return Model.builder().metadata(this.getMetadata()).addShapes(this);
    }

    @Deprecated
    public <T extends KnowledgeIndex> T getKnowledge(Class<T> type) {
        return (T)this.getKnowledge(type, m -> {
            try {
                return (KnowledgeIndex)type.getConstructor(Model.class).newInstance(this);
            }
            catch (NoSuchMethodException e) {
                String message = String.format("KnowledgeIndex for type `%s` does not expose a public constructor that accepts a Model", type);
                throw new RuntimeException(message, e);
            }
            catch (ReflectiveOperationException e) {
                String message = String.format("Unable to create a KnowledgeIndex for type `%s`: %s", type, e.getMessage());
                throw new RuntimeException(message, e);
            }
        });
    }

    public <T extends KnowledgeIndex> T getKnowledge(Class<T> type, Function<Model, T> constructor) {
        return (T)this.blackboard.computeIfAbsent(type, t -> (KnowledgeIndex)constructor.apply(this));
    }

    private static final class TraitCache {
        private final Map<ShapeId, Set<Shape>> traitIdsToShapes = new HashMap<ShapeId, Set<Shape>>();
        private final Map<Class<? extends Trait>, Set<Shape>> traitsToShapes = new HashMap<Class<? extends Trait>, Set<Shape>>();

        TraitCache(Collection<Shape> shapes) {
            for (Shape shape : shapes) {
                for (Trait trait : shape.getAllTraits().values()) {
                    this.traitIdsToShapes.computeIfAbsent(trait.toShapeId(), id -> new HashSet()).add(shape);
                    this.traitsToShapes.computeIfAbsent(trait.getClass(), id -> new HashSet()).add(shape);
                }
            }
        }
    }

    public static final class Builder
    implements SmithyBuilder<Model> {
        private final Map<String, Node> metadata = new HashMap<String, Node>();
        private final Map<ShapeId, Shape> shapeMap = new HashMap<ShapeId, Shape>();

        private Builder() {
        }

        public Builder metadata(Map<String, Node> metadata) {
            this.clearMetadata();
            this.metadata.putAll(metadata);
            return this;
        }

        public Builder putMetadataProperty(String key, Node value) {
            this.metadata.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }

        public Builder removeMetadataProperty(String key) {
            this.metadata.remove(key);
            return this;
        }

        public Builder clearMetadata() {
            this.metadata.clear();
            return this;
        }

        public Builder addShape(Shape shape) {
            if (!shape.isMemberShape()) {
                this.shapeMap.put(shape.getId(), shape);
                for (MemberShape memberShape : shape.members()) {
                    this.shapeMap.put(memberShape.getId(), memberShape);
                }
            }
            return this;
        }

        public Builder addShapes(Model model) {
            this.shapeMap.putAll(model.shapeMap);
            return this;
        }

        public <S extends Shape> Builder addShapes(Collection<S> shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder addShapes(Shape ... shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder removeShape(ShapeId shapeId) {
            if (this.shapeMap.containsKey(shapeId)) {
                Shape previous = this.shapeMap.get(shapeId);
                this.shapeMap.remove(shapeId);
                for (MemberShape memberShape : previous.members()) {
                    this.shapeMap.remove(memberShape.getId());
                }
            }
            return this;
        }

        public Model build() {
            return new Model(this);
        }
    }
}

