/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.SetUtils;

public abstract class EntityShape
extends Shape {
    private final Set<ShapeId> resources;
    private final Set<ShapeId> operations;

    EntityShape(Builder<?, ?> builder) {
        super(builder, false);
        this.resources = SetUtils.orderedCopyOf((Collection)((Builder)builder).resources);
        this.operations = SetUtils.orderedCopyOf((Collection)((Builder)builder).operations);
    }

    public final Set<ShapeId> getResources() {
        return this.resources;
    }

    public final Set<ShapeId> getOperations() {
        return this.operations;
    }

    public Set<ShapeId> getAllOperations() {
        return this.getOperations();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        EntityShape o = (EntityShape)other;
        return this.getResources().equals(o.getResources()) && this.getAllOperations().equals(o.getAllOperations());
    }

    public static abstract class Builder<B extends Builder<?, ?>, S extends EntityShape>
    extends AbstractShapeBuilder<B, S> {
        private final Set<ShapeId> resources = new LinkedHashSet<ShapeId>();
        private final Set<ShapeId> operations = new LinkedHashSet<ShapeId>();

        public B operations(Collection<ShapeId> ids) {
            this.clearOperations();
            this.operations.addAll(ids);
            return (B)this;
        }

        public B addOperation(ToShapeId id) {
            this.operations.add(id.toShapeId());
            return (B)this;
        }

        public B addOperation(String id) {
            return this.addOperation(ShapeId.from(id));
        }

        public B removeOperation(ToShapeId id) {
            this.operations.remove(id.toShapeId());
            return (B)this;
        }

        public B clearOperations() {
            this.operations.clear();
            return (B)this;
        }

        public B resources(Collection<ShapeId> ids) {
            this.clearResources();
            this.resources.addAll(ids);
            return (B)this;
        }

        public B addResource(ToShapeId id) {
            this.resources.add(id.toShapeId());
            return (B)this;
        }

        public B addResource(String id) {
            return this.addResource(ShapeId.from(id));
        }

        public B removeResource(ToShapeId id) {
            this.resources.remove(id.toShapeId());
            return (B)this;
        }

        public B clearResources() {
            this.resources.clear();
            return (B)this;
        }
    }
}

