/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.Set;
import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

final class NonNumericFloatValuesPlugin
implements NodeValidatorPlugin {
    private static final Set<String> NON_NUMERIC_FLOAT_VALUES = Node.NonNumericFloat.stringRepresentations();

    NonNumericFloatValuesPlugin() {
    }

    @Override
    public void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
        if (!shape.isFloatShape() && !shape.isDoubleShape() || !value.isStringNode()) {
            return;
        }
        String nodeValue = value.expectStringNode().getValue();
        if (!NON_NUMERIC_FLOAT_VALUES.contains(nodeValue)) {
            emitter.accept(value, String.format("Value for `%s` must either be numeric or one of the following strings: [\"%s\"], but was \"%s\"", shape.getId(), String.join((CharSequence)"\", \"", NON_NUMERIC_FLOAT_VALUES), nodeValue));
        }
    }
}

