/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;

public final class HttpBindingIndex
implements KnowledgeIndex {
    private final Model model;
    private final Map<ShapeId, List<HttpBinding>> requestBindings = new HashMap<ShapeId, List<HttpBinding>>();
    private final Map<ShapeId, List<HttpBinding>> responseBindings = new HashMap<ShapeId, List<HttpBinding>>();

    public HttpBindingIndex(Model model) {
        this.model = model;
        OperationIndex opIndex = OperationIndex.of(model);
        model.shapes(OperationShape.class).forEach(shape -> {
            if (shape.getTrait(HttpTrait.class).isPresent()) {
                this.requestBindings.put(shape.getId(), this.computeRequestBindings(opIndex, (OperationShape)shape));
                this.responseBindings.put(shape.getId(), this.computeResponseBindings(opIndex, (OperationShape)shape));
            } else {
                this.requestBindings.put(shape.getId(), ListUtils.of());
                this.responseBindings.put(shape.getId(), ListUtils.of());
            }
        });
        model.shapes(StructureShape.class).flatMap(shape -> Trait.flatMapStream(shape, ErrorTrait.class)).forEach(pair -> this.responseBindings.put(((StructureShape)pair.getLeft()).getId(), this.createStructureBindings((StructureShape)pair.getLeft(), false)));
    }

    public static HttpBindingIndex of(Model model) {
        return model.getKnowledge(HttpBindingIndex.class, HttpBindingIndex::new);
    }

    public static boolean hasHttpRequestBindings(Shape shape) {
        return shape.hasTrait(HttpHeaderTrait.class) || shape.hasTrait(HttpPrefixHeadersTrait.class) || shape.hasTrait(HttpPayloadTrait.class) || shape.hasTrait(HttpQueryTrait.class) || shape.hasTrait(HttpLabelTrait.class);
    }

    public static boolean hasHttpResponseBindings(Shape shape) {
        return shape.hasTrait(HttpHeaderTrait.class) || shape.hasTrait(HttpPrefixHeadersTrait.class) || shape.hasTrait(HttpPayloadTrait.class);
    }

    private HttpTrait getHttpTrait(ToShapeId operation) {
        ShapeId id = operation.toShapeId();
        return this.model.getShape(id).orElseThrow(() -> new IllegalArgumentException(id + " is not a valid shape")).asOperationShape().orElseThrow(() -> new IllegalArgumentException(id + " is not an operation shape")).getTrait(HttpTrait.class).orElseThrow(() -> new IllegalArgumentException(id + " has no http binding trait"));
    }

    public int getResponseCode(ToShapeId shapeOrId) {
        ShapeId id = shapeOrId.toShapeId();
        Shape shape = this.model.getShape(id).orElseThrow(() -> new IllegalArgumentException("Shape not found " + id));
        if (shape.isOperationShape()) {
            return this.getHttpTrait(id).getCode();
        }
        if (shape.getTrait(HttpErrorTrait.class).isPresent()) {
            return shape.getTrait(HttpErrorTrait.class).get().getCode();
        }
        if (shape.getTrait(ErrorTrait.class).isPresent()) {
            return shape.getTrait(ErrorTrait.class).get().getDefaultHttpStatusCode();
        }
        throw new IllegalStateException(shape + " must be an operation or error structure");
    }

    public Map<String, HttpBinding> getRequestBindings(ToShapeId operationShapeOrId) {
        ShapeId id = operationShapeOrId.toShapeId();
        this.validateRequestBindingShapeId(id);
        return this.requestBindings.get(id).stream().collect(Collectors.toMap(HttpBinding::getMemberName, Function.identity()));
    }

    private void validateRequestBindingShapeId(ShapeId id) {
        if (!this.requestBindings.containsKey(id)) {
            throw new IllegalArgumentException(id + " does not reference an operation with http bindings");
        }
    }

    public List<HttpBinding> getRequestBindings(ToShapeId operationShapeOrId, HttpBinding.Location requestLocation) {
        ShapeId id = operationShapeOrId.toShapeId();
        this.validateRequestBindingShapeId(id);
        return this.requestBindings.get(id).stream().filter(binding -> binding.getLocation() == requestLocation).collect(Collectors.toList());
    }

    public Map<String, HttpBinding> getResponseBindings(ToShapeId shapeOrId) {
        ShapeId id = shapeOrId.toShapeId();
        this.validateResponseBindingShapeId(id);
        return this.responseBindings.get(id).stream().collect(Collectors.toMap(HttpBinding::getMemberName, Function.identity()));
    }

    private void validateResponseBindingShapeId(ShapeId id) {
        if (!this.responseBindings.containsKey(id)) {
            throw new IllegalArgumentException(id + " does not reference an operation or error structure");
        }
    }

    public List<HttpBinding> getResponseBindings(ToShapeId shapeOrId, HttpBinding.Location bindingLocation) {
        ShapeId id = shapeOrId.toShapeId();
        this.validateResponseBindingShapeId(id);
        return this.responseBindings.get(id).stream().filter(binding -> binding.getLocation() == bindingLocation).collect(Collectors.toList());
    }

    public TimestampFormatTrait.Format determineTimestampFormat(ToShapeId member, HttpBinding.Location location, TimestampFormatTrait.Format defaultFormat) {
        return this.model.getShape(member.toShapeId()).flatMap(shape -> shape.getMemberTrait(this.model, TimestampFormatTrait.class)).map(TimestampFormatTrait::getFormat).orElseGet(() -> {
            switch (location) {
                case PREFIX_HEADERS: 
                case HEADER: {
                    return TimestampFormatTrait.Format.HTTP_DATE;
                }
                case QUERY: 
                case LABEL: {
                    return TimestampFormatTrait.Format.DATE_TIME;
                }
            }
            return defaultFormat;
        });
    }

    public Optional<String> determineRequestContentType(ToShapeId operation, String documentContentType) {
        return this.determineRequestContentType(operation, documentContentType, null);
    }

    public Optional<String> determineRequestContentType(ToShapeId operation, String documentContentType, String eventStreamContentType) {
        Collection<HttpBinding> bindings = this.getRequestBindings(operation).values();
        return Optional.ofNullable(this.determineContentType(bindings, documentContentType, eventStreamContentType));
    }

    public Optional<String> determineResponseContentType(ToShapeId operationOrError, String documentContentType) {
        return this.determineResponseContentType(operationOrError, documentContentType, null);
    }

    public Optional<String> determineResponseContentType(ToShapeId operationOrError, String documentContentType, String eventStreamContentType) {
        Collection<HttpBinding> bindings = this.getResponseBindings(operationOrError).values();
        return Optional.ofNullable(this.determineContentType(bindings, documentContentType, eventStreamContentType));
    }

    private String determineContentType(Collection<HttpBinding> bindings, String documentContentType, String eventStreamContentType) {
        for (HttpBinding binding : bindings) {
            if (binding.getLocation() == HttpBinding.Location.DOCUMENT) {
                return documentContentType;
            }
            if (binding.getLocation() != HttpBinding.Location.PAYLOAD) continue;
            Shape target = this.model.getShape(binding.getMember().getTarget()).orElse(null);
            if (target == null) break;
            if (StreamingTrait.isEventStream(target)) {
                return eventStreamContentType;
            }
            if (target.isDocumentShape() || target.isStructureShape()) {
                return documentContentType;
            }
            if (target.getTrait(MediaTypeTrait.class).isPresent()) {
                return target.getTrait(MediaTypeTrait.class).get().getValue();
            }
            if (target.isBlobShape()) {
                return "application/octet-stream";
            }
            if (!target.isStringShape()) continue;
            return "text/plain";
        }
        return null;
    }

    private List<HttpBinding> computeRequestBindings(OperationIndex opIndex, OperationShape shape) {
        return opIndex.getInput(shape.getId()).map(input -> this.createStructureBindings((StructureShape)input, true)).orElseGet(Collections::emptyList);
    }

    private List<HttpBinding> computeResponseBindings(OperationIndex opIndex, OperationShape shape) {
        return opIndex.getOutput(shape.getId()).map(output -> this.createStructureBindings((StructureShape)output, false)).orElseGet(Collections::emptyList);
    }

    private List<HttpBinding> createStructureBindings(StructureShape struct, boolean isRequest) {
        ArrayList<HttpBinding> bindings = new ArrayList<HttpBinding>();
        ArrayList<MemberShape> unbound = new ArrayList<MemberShape>();
        boolean foundPayload = false;
        for (MemberShape member2 : struct.getAllMembers().values()) {
            Trait trait;
            if (member2.getTrait(HttpHeaderTrait.class).isPresent()) {
                trait = member2.getTrait(HttpHeaderTrait.class).get();
                bindings.add(new HttpBinding(member2, HttpBinding.Location.HEADER, ((StringTrait)trait).getValue(), trait));
                continue;
            }
            if (member2.getTrait(HttpPrefixHeadersTrait.class).isPresent()) {
                trait = member2.getTrait(HttpPrefixHeadersTrait.class).get();
                bindings.add(new HttpBinding(member2, HttpBinding.Location.PREFIX_HEADERS, ((StringTrait)trait).getValue(), trait));
                continue;
            }
            if (isRequest && member2.getTrait(HttpQueryTrait.class).isPresent()) {
                trait = member2.getTrait(HttpQueryTrait.class).get();
                bindings.add(new HttpBinding(member2, HttpBinding.Location.QUERY, ((StringTrait)trait).getValue(), trait));
                continue;
            }
            if (member2.getTrait(HttpPayloadTrait.class).isPresent()) {
                foundPayload = true;
                trait = member2.getTrait(HttpPayloadTrait.class).get();
                bindings.add(new HttpBinding(member2, HttpBinding.Location.PAYLOAD, member2.getMemberName(), trait));
                continue;
            }
            if (isRequest && member2.getTrait(HttpLabelTrait.class).isPresent()) {
                trait = member2.getTrait(HttpLabelTrait.class).get();
                bindings.add(new HttpBinding(member2, HttpBinding.Location.LABEL, member2.getMemberName(), trait));
                continue;
            }
            unbound.add(member2);
        }
        if (!unbound.isEmpty()) {
            if (foundPayload) {
                unbound.forEach(member -> bindings.add(new HttpBinding((MemberShape)member, HttpBinding.Location.UNBOUND, member.getMemberName(), null)));
            } else {
                unbound.forEach(member -> bindings.add(new HttpBinding((MemberShape)member, HttpBinding.Location.DOCUMENT, member.getMemberName(), null)));
            }
        }
        return bindings;
    }
}

