/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlModelParser;
import software.amazon.smithy.model.loader.IdlTextParser;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.utils.Pair;

final class IdlNodeParser {
    private IdlNodeParser() {
    }

    static Node parseNode(IdlModelParser parser) {
        char c = parser.peek();
        switch (c) {
            case '{': {
                return IdlNodeParser.parseObjectNode(parser);
            }
            case '[': {
                return IdlNodeParser.parseArrayNode(parser);
            }
            case '\"': {
                if (IdlNodeParser.peekTextBlock(parser)) {
                    return IdlNodeParser.parseTextBlock(parser);
                }
                SourceLocation location = parser.currentLocation();
                return new StringNode(IdlTextParser.parseQuotedString(parser), location);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return parser.parseNumberNode();
            }
        }
        SourceLocation location = parser.currentLocation();
        return IdlNodeParser.parseNodeTextWithKeywords(parser, location, ParserUtils.parseShapeId(parser));
    }

    static Node parseNodeTextWithKeywords(IdlModelParser parser, SourceLocation location, String text) {
        switch (text) {
            case "true": {
                return new BooleanNode(true, location);
            }
            case "false": {
                return new BooleanNode(false, location);
            }
            case "null": {
                return new NullNode(location);
            }
        }
        Pair<StringNode, Consumer<String>> pair = StringNode.createLazyString(text, location);
        Consumer consumer = (Consumer)pair.right;
        parser.onShapeTarget(text, location, id -> consumer.accept(id.toString()));
        return (Node)pair.left;
    }

    static boolean peekTextBlock(IdlModelParser parser) {
        return parser.peek() == '\"' && parser.peek(1) == '\"' && parser.peek(2) == '\"';
    }

    static Node parseTextBlock(IdlModelParser parser) {
        SourceLocation location = parser.currentLocation();
        parser.expect('\"');
        parser.expect('\"');
        parser.expect('\"');
        return new StringNode(IdlTextParser.parseQuotedTextAndTextBlock(parser, true), location);
    }

    static ObjectNode parseObjectNode(IdlModelParser parser) {
        char c;
        parser.increaseNestingLevel();
        SourceLocation location = parser.currentLocation();
        LinkedHashMap<StringNode, Node> entries = new LinkedHashMap<StringNode, Node>();
        parser.expect('{');
        parser.ws();
        while (!parser.eof() && (c = parser.peek()) != '}') {
            SourceLocation keyLocation = parser.currentLocation();
            String key = IdlNodeParser.parseNodeObjectKey(parser);
            parser.ws();
            parser.expect(':');
            parser.ws();
            Node value = IdlNodeParser.parseNode(parser);
            entries.put(new StringNode(key, keyLocation), value);
            parser.ws();
            if (parser.peek() != ',') break;
            parser.skip();
            parser.ws();
        }
        parser.expect('}');
        parser.decreaseNestingLevel();
        return new ObjectNode(entries, location);
    }

    static String parseNodeObjectKey(IdlModelParser parser) {
        if (parser.peek() == '\"') {
            return IdlTextParser.parseQuotedString(parser);
        }
        return ParserUtils.parseIdentifier(parser);
    }

    private static ArrayNode parseArrayNode(IdlModelParser parser) {
        char c;
        parser.increaseNestingLevel();
        SourceLocation location = parser.currentLocation();
        ArrayList<Node> items = new ArrayList<Node>();
        parser.expect('[');
        parser.ws();
        while (!parser.eof() && (c = parser.peek()) != ']') {
            items.add(IdlNodeParser.parseNode(parser));
            parser.ws();
            if (parser.peek() != ',') break;
            parser.skip();
            parser.ws();
        }
        parser.expect(']');
        parser.decreaseNestingLevel();
        return new ArrayNode(items, location);
    }
}

