/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthDefinitionTrait;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.Trait;

public final class ServiceIndex
implements KnowledgeIndex {
    private final WeakReference<Model> model;
    private final Set<ShapeId> protocolTraits;
    private final Set<ShapeId> authTraits;

    public ServiceIndex(Model model) {
        this.model = new WeakReference<Model>(model);
        this.protocolTraits = model.shapes().filter(shape -> shape.hasTrait(ProtocolDefinitionTrait.class)).map(Shape::getId).collect(Collectors.toSet());
        this.authTraits = model.shapes().filter(shape -> shape.hasTrait(AuthDefinitionTrait.class)).map(Shape::getId).collect(Collectors.toSet());
    }

    public Map<ShapeId, Trait> getProtocols(ToShapeId service) {
        return this.getTraitMapInSet(service, this.protocolTraits);
    }

    private Map<ShapeId, Trait> getTraitMapInSet(ToShapeId service, Set<ShapeId> haystack) {
        return this.getModel().getShape(service.toShapeId()).flatMap(Shape::asServiceShape).map(shape -> shape.getAllTraits().values().stream().filter(trait -> haystack.contains(trait.toShapeId())).collect(Collectors.toMap(Trait::toShapeId, Function.identity(), (a, b) -> b, TreeMap::new))).orElse(Collections.emptyMap());
    }

    private Model getModel() {
        return Objects.requireNonNull((Model)this.model.get(), "The dereferenced WeakReference<Model> is null");
    }

    public Map<ShapeId, Trait> getAuthSchemes(ToShapeId service) {
        return this.getTraitMapInSet(service, this.authTraits);
    }

    public Map<ShapeId, Trait> getEffectiveAuthSchemes(ToShapeId service) {
        return this.getModel().getShape(service.toShapeId()).flatMap(Shape::asServiceShape).map(shape -> {
            Map<ShapeId, Trait> result = this.getAuthTraitValues((Shape)shape, (Shape)shape);
            if (result == null) {
                result = new TreeMap<ShapeId, Trait>();
                for (Map.Entry<ShapeId, Trait> traitEntry : shape.getAllTraits().entrySet()) {
                    if (!this.authTraits.contains(traitEntry.getKey())) continue;
                    result.put(traitEntry.getKey(), traitEntry.getValue());
                }
            }
            return result;
        }).orElse(Collections.emptyMap());
    }

    public Map<ShapeId, Trait> getEffectiveAuthSchemes(ToShapeId service, ToShapeId operation) {
        Shape serviceShape = this.getModel().getShape(service.toShapeId()).flatMap(Shape::asServiceShape).orElse(null);
        if (serviceShape == null) {
            return Collections.emptyMap();
        }
        return this.getModel().getShape(operation.toShapeId()).flatMap(Shape::asOperationShape).map(operationShape -> {
            Map<ShapeId, Trait> result = this.getAuthTraitValues(serviceShape, (Shape)operationShape);
            return result != null ? result : this.getEffectiveAuthSchemes(service);
        }).orElse(Collections.emptyMap());
    }

    private Map<ShapeId, Trait> getAuthTraitValues(Shape service, Shape subject) {
        if (!subject.hasTrait(AuthTrait.class)) {
            return null;
        }
        AuthTrait authTrait = subject.expectTrait(AuthTrait.class);
        LinkedHashMap<ShapeId, Trait> result = new LinkedHashMap<ShapeId, Trait>();
        for (ShapeId value : authTrait.getValues()) {
            service.findTrait(value).ifPresent(trait -> result.put(value, (Trait)trait));
        }
        return result;
    }
}

