/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        HashMap<Shape, Map<ShapeId, List<ShapeId>>> shapeToTraitConflicts = new HashMap<Shape, Map<ShapeId, List<ShapeId>>>();
        for (Shape shape : model.getShapesWithTrait(TraitDefinition.class)) {
            TraitDefinition trait = shape.expectTrait(TraitDefinition.class);
            if (trait.getConflicts().isEmpty()) continue;
            this.findAndCollectConflicts(model, shape.getId(), trait.getConflicts(), shapeToTraitConflicts);
        }
        if (shapeToTraitConflicts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Map.Entry entry : shapeToTraitConflicts.entrySet()) {
            events.add(this.emitForConflicts((Shape)entry.getKey(), (Map)entry.getValue()));
        }
        return events;
    }

    private void findAndCollectConflicts(Model model, ShapeId trait, List<ShapeId> conflicts, Map<Shape, Map<ShapeId, List<ShapeId>>> shapeToTraitConflicts) {
        for (Shape shape : model.getShapesWithTrait(trait)) {
            for (ShapeId conflict : conflicts) {
                if (!shape.hasTrait(conflict)) continue;
                shapeToTraitConflicts.computeIfAbsent(shape, id -> new HashMap()).computeIfAbsent(trait, id -> new ArrayList()).add(conflict);
            }
        }
    }

    private ValidationEvent emitForConflicts(Shape shape, Map<ShapeId, List<ShapeId>> conflicts) {
        return this.error(shape, "Found conflicting traits on " + (Object)((Object)shape.getType()) + " shape: " + conflicts.entrySet().stream().flatMap(this::lines).sorted().collect(Collectors.joining(", ")));
    }

    private Stream<String> lines(Map.Entry<ShapeId, List<ShapeId>> entry) {
        String prefix = "`" + Trait.getIdiomaticTraitName(entry.getKey()) + "` conflicts with `";
        return entry.getValue().stream().map(value -> prefix + Trait.getIdiomaticTraitName(value) + "`");
    }
}

