/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MemberShape
extends Shape
implements ToSmithyBuilder<MemberShape> {
    private final ShapeId target;
    private final String memberName;

    private MemberShape(Builder builder) {
        super(builder, true);
        this.target = (ShapeId)SmithyBuilder.requiredState((String)"target", (Object)builder.target);
        this.memberName = this.getId().getMember().orElse("");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)MemberShape.builder().from(this)).target(this.target);
    }

    public ShapeId getContainer() {
        return this.getId().withoutMember();
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.memberShape(this);
    }

    @Override
    public Optional<MemberShape> asMemberShape() {
        return Optional.of(this);
    }

    public ShapeId getTarget() {
        return this.target;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public boolean isRequired() {
        return this.findTrait("required").isPresent();
    }

    public boolean isOptional() {
        return !this.isRequired();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getTarget().equals(((MemberShape)other).getTarget());
    }

    @Override
    public <T extends Trait> Optional<T> getMemberTrait(Model model, Class<T> trait) {
        return OptionalUtils.or(this.getTrait(trait), () -> model.getShape(this.getTarget()).flatMap(targetedShape -> targetedShape.getTrait(trait)));
    }

    @Override
    public Optional<Trait> findMemberTrait(Model model, String traitName) {
        return OptionalUtils.or(this.findTrait(traitName), () -> model.getShape(this.getTarget()).flatMap(targetedShape -> targetedShape.findTrait(traitName)));
    }

    public static class Builder
    extends AbstractShapeBuilder<Builder, MemberShape> {
        private ShapeId target;

        public MemberShape build() {
            return new MemberShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.MEMBER;
        }

        public Builder target(ToShapeId shapeId) {
            this.target = shapeId.toShapeId();
            return this;
        }

        public Builder target(String shapeId) {
            return this.target(ShapeId.from(shapeId));
        }
    }
}

