/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.utils.SimpleParser;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class ParserUtils {
    private ParserUtils() {
    }

    public static String parseNumber(SimpleParser parser) {
        int startPosition = parser.position();
        char current = parser.peek();
        if (current == '-') {
            parser.skip();
            if (!ParserUtils.isDigit(parser.peek())) {
                throw parser.syntax(ParserUtils.createInvalidString(parser, startPosition, "'-' must be followed by a digit"));
            }
        }
        parser.consumeUntilNoLongerMatches(ParserUtils::isDigit);
        char peek = parser.peek();
        if (peek == '.') {
            parser.skip();
            if (parser.consumeUntilNoLongerMatches(ParserUtils::isDigit) == 0) {
                throw parser.syntax(ParserUtils.createInvalidString(parser, startPosition, "'.' must be followed by a digit"));
            }
        }
        if ((peek = parser.peek()) == 'e' || peek == 'E') {
            parser.skip();
            peek = parser.peek();
            if (peek == '+' || peek == '-') {
                parser.skip();
            }
            if (parser.consumeUntilNoLongerMatches(ParserUtils::isDigit) == 0) {
                throw parser.syntax(ParserUtils.createInvalidString(parser, startPosition, "'e', '+', and '-' must be followed by a digit"));
            }
        }
        return parser.sliceFrom(startPosition);
    }

    private static String createInvalidString(SimpleParser parser, int startPosition, String message) {
        String lexeme = parser.sliceFrom(startPosition);
        return String.format("Invalid number '%s': %s", lexeme, message);
    }

    public static String parseIdentifier(SimpleParser parser) {
        int start = parser.position();
        ParserUtils.consumeIdentifier(parser);
        return parser.sliceFrom(start);
    }

    public static String parseRootShapeId(SimpleParser parser) {
        int start = parser.position();
        ParserUtils.consumeShapeId(parser, false);
        return parser.sliceFrom(start);
    }

    public static String parseShapeId(SimpleParser parser) {
        int start = parser.position();
        ParserUtils.consumeShapeId(parser, true);
        return parser.sliceFrom(start);
    }

    private static void consumeShapeId(SimpleParser parser, boolean parseMember) {
        ParserUtils.consumeNamespace(parser);
        if (parser.peek() == '#') {
            parser.skip();
            ParserUtils.consumeIdentifier(parser);
        }
        if (parseMember && parser.peek() == '$') {
            parser.skip();
            ParserUtils.consumeIdentifier(parser);
        }
    }

    public static void consumeNamespace(SimpleParser parser) {
        ParserUtils.consumeIdentifier(parser);
        while (parser.peek() == '.') {
            parser.skip();
            ParserUtils.consumeIdentifier(parser);
        }
    }

    public static void consumeIdentifier(SimpleParser parser) {
        if (!ParserUtils.isIdentifierStart(parser.peek())) {
            throw parser.syntax("Expected a valid identifier character, but found '" + parser.peekSingleCharForMessage() + '\'');
        }
        parser.consumeUntilNoLongerMatches(ParserUtils::isValidIdentifierCharacter);
    }

    public static boolean isValidIdentifierCharacter(char c) {
        return ParserUtils.isIdentifierStart(c) || ParserUtils.isDigit(c);
    }

    public static boolean isIdentifierStart(char c) {
        return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

