/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Optional;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.PaginatedTrait;

public final class PaginationInfo {
    private final ServiceShape service;
    private final OperationShape operation;
    private final StructureShape input;
    private final StructureShape output;
    private final PaginatedTrait paginatedTrait;
    private final MemberShape inputToken;
    private final MemberShape outputToken;
    private final MemberShape pageSize;
    private final MemberShape items;

    PaginationInfo(ServiceShape service, OperationShape operation, StructureShape input, StructureShape output, PaginatedTrait paginatedTrait, MemberShape inputToken, MemberShape outputToken, MemberShape pageSize, MemberShape items) {
        this.service = service;
        this.operation = operation;
        this.input = input;
        this.output = output;
        this.paginatedTrait = paginatedTrait;
        this.inputToken = inputToken;
        this.outputToken = outputToken;
        this.pageSize = pageSize;
        this.items = items;
    }

    public ServiceShape getService() {
        return this.service;
    }

    public OperationShape getOperation() {
        return this.operation;
    }

    public StructureShape getInput() {
        return this.input;
    }

    public StructureShape getOutput() {
        return this.output;
    }

    public PaginatedTrait getPaginatedTrait() {
        return this.paginatedTrait.merge(this.service.getTrait(PaginatedTrait.class).orElse(null));
    }

    public MemberShape getInputTokenMember() {
        return this.inputToken;
    }

    public MemberShape getOutputTokenMember() {
        return this.outputToken;
    }

    public Optional<MemberShape> getItemsMember() {
        return Optional.ofNullable(this.items);
    }

    public Optional<MemberShape> getPageSizeMember() {
        return Optional.ofNullable(this.pageSize);
    }
}

