/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;

public final class ErrorTrait
extends StringTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#error");

    public ErrorTrait(String value, SourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
        if (!this.isClientError() && !this.isServerError()) {
            throw new SourceException(String.format("error trait must be set to client or server, found `%s`", this.getValue()), sourceLocation);
        }
    }

    public ErrorTrait(String value) {
        this(value, SourceLocation.NONE);
    }

    public int getDefaultHttpStatusCode() {
        return this.isClientError() ? 400 : 500;
    }

    public boolean isClientError() {
        return this.getValue().equals("client");
    }

    public boolean isServerError() {
        return this.getValue().equals("server");
    }

    public static final class Provider
    extends StringTrait.Provider<ErrorTrait> {
        public Provider() {
            super(ID, ErrorTrait::new);
        }
    }
}

