/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Objects;
import java.util.function.Function;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;

public abstract class AnnotationTrait
implements Trait {
    private final ShapeId id;
    private final ObjectNode node;

    public AnnotationTrait(ShapeId id, ObjectNode node) {
        this.id = Objects.requireNonNull(id);
        this.node = Objects.requireNonNull(node);
    }

    @Override
    public final ShapeId toShapeId() {
        return this.id;
    }

    @Override
    public final Node toNode() {
        return this.node;
    }

    @Override
    public final SourceLocation getSourceLocation() {
        return this.node.getSourceLocation();
    }

    public int hashCode() {
        return this.toShapeId().hashCode() * 17 + this.node.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Trait b = (Trait)other;
        if (!this.toShapeId().equals(b.toShapeId())) {
            return false;
        }
        return this.node.equals(b.toNode());
    }

    public static class Provider<T extends AnnotationTrait>
    extends AbstractTrait.Provider {
        private final Function<ObjectNode, T> traitFactory;

        public Provider(ShapeId id, Function<ObjectNode, T> traitFactory) {
            super(id);
            this.traitFactory = traitFactory;
        }

        public T createTrait(ShapeId id, Node value) {
            if (value.isObjectNode()) {
                return (T)((AnnotationTrait)this.traitFactory.apply(value.expectObjectNode()));
            }
            throw new ExpectationNotMetException(String.format("Annotation traits  must be an object or omitted in the IDL, but found %s", new Object[]{value.getType()}), value);
        }
    }
}

