/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.loader.IdlModelParser;

final class IdlTextParser {
    private IdlTextParser() {
    }

    static String parseQuotedString(IdlModelParser parser) {
        parser.expect('\"');
        if (parser.charPeek() == '\"') {
            parser.skip();
            return "";
        }
        return IdlTextParser.parseQuotedTextAndTextBlock(parser, false);
    }

    static String parseQuotedTextAndTextBlock(IdlModelParser parser, boolean triple) {
        char next;
        int start = parser.position();
        while (!parser.eof() && ((next = parser.charPeek()) != '\"' || triple && (parser.charPeek(1) != '\"' || parser.charPeek(2) != '\"'))) {
            parser.skip();
            if (next != '\\') continue;
            parser.skip();
        }
        String result = parser.sliceFrom(start);
        parser.expect('\"');
        if (triple) {
            parser.expect('\"');
            parser.expect('\"');
        }
        return IdlTextParser.parseStringContents(parser, result, triple);
    }

    private static String parseStringContents(IdlModelParser parser, String lexeme, boolean triple) {
        lexeme = IdlTextParser.normalizeLineEndings(lexeme);
        if (triple) {
            lexeme = IdlTextParser.formatTextBlock(parser, lexeme);
        }
        StringBuilder result = new StringBuilder(lexeme.length());
        State state = State.NORMAL;
        int hexCount = 0;
        int unicode = 0;
        block17: for (int i = 0; i < lexeme.length(); ++i) {
            char c = lexeme.charAt(i);
            switch (state) {
                case NORMAL: {
                    if (c == '\\') {
                        state = State.AFTER_ESCAPE;
                        continue block17;
                    }
                    result.append(c);
                    continue block17;
                }
                case AFTER_ESCAPE: {
                    state = State.NORMAL;
                    switch (c) {
                        case '\"': {
                            result.append('\"');
                            continue block17;
                        }
                        case '\\': {
                            result.append('\\');
                            continue block17;
                        }
                        case '/': {
                            result.append('/');
                            continue block17;
                        }
                        case 'b': {
                            result.append('\b');
                            continue block17;
                        }
                        case 'f': {
                            result.append('\f');
                            continue block17;
                        }
                        case 'n': {
                            result.append('\n');
                            continue block17;
                        }
                        case 'r': {
                            result.append('\r');
                            continue block17;
                        }
                        case 't': {
                            result.append('\t');
                            continue block17;
                        }
                        case 'u': {
                            state = State.UNICODE;
                            continue block17;
                        }
                        case '\n': {
                            continue block17;
                        }
                    }
                    throw parser.syntax("Invalid escape found in string: `\\" + c + "`");
                }
                case UNICODE: {
                    if (c >= '0' && c <= '9') {
                        unicode = unicode << 4 | c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        unicode = unicode << 4 | 10 + c - 97;
                    } else if (c >= 'A' && c <= 'F') {
                        unicode = unicode << 4 | 10 + c - 65;
                    } else {
                        throw parser.syntax("Invalid unicode escape character: `" + c + "`");
                    }
                    if (++hexCount != 4) continue block17;
                    result.append((char)unicode);
                    hexCount = 0;
                    state = State.NORMAL;
                    continue block17;
                }
                default: {
                    throw new IllegalStateException("Unreachable");
                }
            }
        }
        if (state == State.UNICODE) {
            throw parser.syntax("Invalid unclosed unicode escape found in string");
        }
        return result.toString();
    }

    private static String normalizeLineEndings(String lexeme) {
        if (!IdlTextParser.containsCarriageReturn(lexeme)) {
            return lexeme;
        }
        StringBuilder builder = new StringBuilder(lexeme.length());
        for (int i = 0; i < lexeme.length(); ++i) {
            char c = lexeme.charAt(i);
            if (c != '\r') {
                builder.append(c);
                continue;
            }
            if (i < lexeme.length() - 1 && lexeme.charAt(i + 1) == '\n') {
                ++i;
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    private static boolean containsCarriageReturn(String lexeme) {
        for (int i = 0; i < lexeme.length(); ++i) {
            if (lexeme.charAt(i) != '\r') continue;
            return true;
        }
        return false;
    }

    private static String formatTextBlock(IdlModelParser parser, String lexeme) {
        int i;
        if (lexeme.isEmpty()) {
            throw parser.syntax("Invalid text block: text block is empty");
        }
        if (lexeme.charAt(0) != '\n') {
            throw parser.syntax("Invalid text block: text block must start with a new line (LF)");
        }
        StringBuilder buffer = new StringBuilder();
        int longestPadding = Integer.MAX_VALUE;
        String[] lines = lexeme.split("\n", -1);
        for (i = 1; i < lines.length; ++i) {
            int padding = IdlTextParser.computeLeadingWhitespace(lines[i], i == lines.length - 1);
            if (padding <= -1 || padding >= longestPadding) continue;
            longestPadding = padding;
        }
        for (i = 1; i < lines.length; ++i) {
            String formattedLine;
            String line = lines[i];
            if (!line.isEmpty() && (formattedLine = IdlTextParser.createTextBlockLine(line, longestPadding)) != null) {
                buffer.append(formattedLine);
            }
            if (i >= lines.length - 1) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private static int computeLeadingWhitespace(String line, boolean isLastLine) {
        if (line.isEmpty()) {
            return -1;
        }
        for (int offset = 0; offset < line.length(); ++offset) {
            if (line.charAt(offset) == ' ') continue;
            return offset;
        }
        return isLastLine ? line.length() : -1;
    }

    private static String createTextBlockLine(String line, int longestPadding) {
        int endPosition;
        int startPosition = Math.min(longestPadding, line.length());
        for (endPosition = line.length() - 1; endPosition > 0 && line.charAt(endPosition) == ' '; --endPosition) {
        }
        return endPosition >= startPosition ? line.substring(startPosition, endPosition + 1) : null;
    }

    static enum State {
        NORMAL,
        AFTER_ESCAPE,
        UNICODE;

    }
}

