/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.ListUtils;

public final class OperationIndex
implements KnowledgeIndex {
    private final Map<ShapeId, StructureShape> inputs = new HashMap<ShapeId, StructureShape>();
    private final Map<ShapeId, StructureShape> outputs = new HashMap<ShapeId, StructureShape>();
    private final Map<ShapeId, List<StructureShape>> errors = new HashMap<ShapeId, List<StructureShape>>();

    public OperationIndex(Model model) {
        model.shapes(OperationShape.class).forEach(operation -> {
            operation.getInput().flatMap(id -> this.getStructure(model, (ToShapeId)id)).ifPresent(shape -> this.inputs.put(operation.getId(), (StructureShape)shape));
            operation.getOutput().flatMap(id -> this.getStructure(model, (ToShapeId)id)).ifPresent(shape -> this.outputs.put(operation.getId(), (StructureShape)shape));
            this.errors.put(operation.getId(), operation.getErrors().stream().map(e -> this.getStructure(model, (ToShapeId)e)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        });
    }

    public Optional<StructureShape> getInput(ToShapeId operation) {
        return Optional.ofNullable(this.inputs.get(operation.toShapeId()));
    }

    public Optional<StructureShape> getOutput(ToShapeId operation) {
        return Optional.ofNullable(this.outputs.get(operation.toShapeId()));
    }

    public List<StructureShape> getErrors(ToShapeId operation) {
        return this.errors.getOrDefault(operation.toShapeId(), ListUtils.of());
    }

    private Optional<StructureShape> getStructure(Model model, ToShapeId id) {
        return model.getShape(id.toShapeId()).flatMap(Shape::asStructureShape);
    }
}

