/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SetUtils;

final class ReplaceShapes {
    private Collection<Shape> replacements;

    ReplaceShapes(Collection<Shape> replacements) {
        this.replacements = Objects.requireNonNull(replacements);
    }

    Model transform(ModelTransformer transformer, Model model) {
        List<Shape> shouldReplace = this.determineShapesToReplace(model);
        if (shouldReplace.isEmpty()) {
            return model;
        }
        this.assertNoShapeChangedType(model, shouldReplace);
        Model.Builder builder = this.createReplacedModelBuilder(model, shouldReplace);
        this.getUpdatedContainers(model, shouldReplace).forEach(builder::addShape);
        return transformer.removeShapes(builder.build(), this.getShapesToRemove(model, shouldReplace));
    }

    private List<Shape> determineShapesToReplace(Model model) {
        return this.replacements.stream().filter(shape -> !model.getShape(shape.getId()).filter(original -> original.equals(shape)).isPresent()).sorted((a, b) -> {
            if (a.isMemberShape() ^ b.isMemberShape()) {
                return a.isMemberShape() ? 1 : -1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    private void assertNoShapeChangedType(Model model, List<Shape> shouldReplace) {
        shouldReplace.stream().flatMap(previous -> Pair.flatMapStream((Object)previous, p -> model.getShape(p.getId()))).filter(pair -> ((Shape)pair.getLeft()).getType() != ((Shape)pair.getRight()).getType()).forEach(pair -> {
            throw new RuntimeException(String.format("Cannot change the type of %s from %s to %s", new Object[]{((Shape)pair.getLeft()).getId(), ((Shape)pair.getLeft()).getType(), ((Shape)pair.getRight()).getType()}));
        });
    }

    private Model.Builder createReplacedModelBuilder(Model model, List<Shape> shouldReplace) {
        Model.Builder builder = model.toBuilder();
        shouldReplace.forEach(shape -> {
            builder.addShape((Shape)shape);
            builder.addShapes(shape.members());
        });
        return builder;
    }

    private Set<Shape> getShapesToRemove(Model model, List<Shape> shouldReplace) {
        return shouldReplace.stream().flatMap(shape -> Pair.flatMapStream((Object)shape, s -> model.getShape(s.getId()))).flatMap(pair -> {
            RemoveShapesVisitor removeShapesVisitor = new RemoveShapesVisitor((Shape)pair.getRight());
            return ((Shape)pair.getLeft()).accept(removeShapesVisitor).stream();
        }).collect(Collectors.toSet());
    }

    private Set<Shape> getUpdatedContainers(Model model, List<Shape> shouldReplace) {
        Map containerToMemberMapping = shouldReplace.stream().flatMap(shape -> OptionalUtils.stream(shape.asMemberShape())).flatMap(member -> Pair.flatMapStream((Object)member, m -> this.findContainerShape(m.getContainer(), model, shouldReplace))).collect(Collectors.groupingBy(Pair::getRight, Collectors.mapping(Pair::getLeft, Collectors.toList())));
        return containerToMemberMapping.entrySet().stream().map(entry -> {
            Shape container = (Shape)entry.getKey();
            List members = (List)entry.getValue();
            for (MemberShape member : members) {
                container = container.accept(new UpdateContainerVisitor(member)).orElse(container);
            }
            return container.equals(entry.getKey()) ? null : container;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Optional<Shape> findContainerShape(ShapeId shapeId, Model model, List<Shape> shouldReplace) {
        Optional<Shape> result = shouldReplace.stream().filter(shape -> shape.getId().equals(shapeId)).findFirst();
        return result.isPresent() ? result : model.getShape(shapeId);
    }

    private static final class UpdateContainerVisitor
    extends ShapeVisitor.Default<Optional<Shape>> {
        private final MemberShape member;

        UpdateContainerVisitor(MemberShape member) {
            this.member = member;
        }

        @Override
        public Optional<Shape> getDefault(Shape shape) {
            return Optional.empty();
        }

        @Override
        public Optional<Shape> listShape(ListShape shape) {
            return shape.getMember() == this.member ? Optional.empty() : Optional.of(((ListShape.Builder)shape.toBuilder().member(this.member)).build());
        }

        @Override
        public Optional<Shape> setShape(SetShape shape) {
            return shape.getMember() == this.member ? Optional.empty() : Optional.of(((SetShape.Builder)shape.toBuilder().member(this.member)).build());
        }

        @Override
        public Optional<Shape> mapShape(MapShape shape) {
            if (this.member.getMemberName().equals("key")) {
                return shape.getKey() == this.member ? Optional.empty() : Optional.of(shape.toBuilder().key(this.member).build());
            }
            return shape.getValue() == this.member ? Optional.empty() : Optional.of(shape.toBuilder().value(this.member).build());
        }

        @Override
        public Optional<Shape> structureShape(StructureShape shape) {
            return shape.getMember(this.member.getMemberName()).filter(oldMember -> !oldMember.equals(this.member)).map(oldMember -> ((StructureShape.Builder)shape.toBuilder().addMember(this.member)).build());
        }

        @Override
        public Optional<Shape> unionShape(UnionShape shape) {
            return shape.getMember(this.member.getMemberName()).filter(oldMember -> oldMember != this.member).map(oldMember -> ((UnionShape.Builder)shape.toBuilder().addMember(this.member)).build());
        }
    }

    private static final class RemoveShapesVisitor
    extends ShapeVisitor.Default<Collection<Shape>> {
        private final Shape previous;

        RemoveShapesVisitor(Shape previous) {
            this.previous = previous;
        }

        @Override
        public Collection<Shape> getDefault(Shape shape) {
            return SetUtils.of();
        }

        @Override
        public Collection<Shape> unionShape(UnionShape shape) {
            return this.onNamedMemberContainer(shape.getAllMembers(), this.previous.asUnionShape().get().getAllMembers());
        }

        @Override
        public Collection<Shape> structureShape(StructureShape shape) {
            return this.onNamedMemberContainer(this.getStructureMemberMap(shape), this.getStructureMemberMap(this.previous.asStructureShape().get()));
        }

        private Map<String, MemberShape> getStructureMemberMap(StructureShape shape) {
            return shape.getAllMembers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private Collection<Shape> onNamedMemberContainer(Map<String, MemberShape> members, Map<String, MemberShape> previousMembers) {
            HashSet<String> removedMembers = new HashSet<String>(previousMembers.keySet());
            removedMembers.removeAll(members.keySet());
            return removedMembers.stream().map(previousMembers::get).collect(Collectors.toSet());
        }
    }
}

