/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ReferencesTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;

public final class ReferencesTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(ReferencesTrait.class)) {
            events.addAll(this.validateShape(model, shape, shape.expectTrait(ReferencesTrait.class)));
        }
        return events;
    }

    private List<ValidationEvent> validateShape(Model model, Shape shape, ReferencesTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ReferencesTrait.Reference reference : trait.getReferences()) {
            ShapeId shapeId;
            Optional<Shape> targetedShape;
            if (shape.isStringShape() && !reference.getIds().isEmpty()) {
                events.add(this.error(shape, trait, "References applied to string shapes cannot contain 'ids': " + reference));
            }
            if (!(targetedShape = model.getShape(shapeId = reference.getResource())).isPresent()) continue;
            if (!targetedShape.get().isResourceShape()) {
                events.add(this.error(shape, trait, String.format("`references` trait reference targets a %s shape not a resource: %s", new Object[]{targetedShape.get().getType(), reference})));
                continue;
            }
            ResourceShape resource = targetedShape.get().asResourceShape().get();
            events.addAll(this.validateSingleReference(model, reference, shape, trait, resource));
        }
        return events;
    }

    private List<ValidationEvent> validateSingleReference(Model model, ReferencesTrait.Reference reference, Shape shape, ReferencesTrait trait, ResourceShape target) {
        if (shape.asStructureShape().isPresent()) {
            return this.validateStructureRef(model, reference, shape.asStructureShape().get(), trait, target);
        }
        if (shape.asStringShape().isPresent()) {
            return this.validateStringShapeRef(reference, shape.asStringShape().get(), trait, target);
        }
        return Collections.emptyList();
    }

    private List<ValidationEvent> validateStringShapeRef(ReferencesTrait.Reference reference, StringShape shape, ReferencesTrait trait, ResourceShape target) {
        if (target.getIdentifiers().size() != 1) {
            return ListUtils.of((Object)this.error(shape, trait, String.format("This string shape contains an invalid reference to %s: %s. References on a string shape can only refer to resource shapes with exactly one entry in its identifiers property, but this shape has the following identifiers: [%s]", target.getId(), reference, ValidationUtils.tickedList(target.getIdentifiers().keySet()))));
        }
        return ListUtils.of();
    }

    private List<ValidationEvent> validateStructureRef(Model model, ReferencesTrait.Reference reference, StructureShape shape, ReferencesTrait trait, ResourceShape target) {
        boolean implicit;
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Map<String, String> resolvedIds = this.resolveIds(reference, target);
        boolean bl = implicit = !resolvedIds.equals(reference.getIds());
        if (!implicit) {
            this.validateExplicitIds(reference, shape, trait, target, resolvedIds, events);
        }
        HashMap<String, ErrorReason> errors = new HashMap<String, ErrorReason>();
        for (String memberName : resolvedIds.values()) {
            if (!shape.getMember(memberName).isPresent()) {
                errors.put(memberName, ErrorReason.NOT_FOUND);
                continue;
            }
            MemberShape structMember = (MemberShape)shape.getMember(memberName).get();
            if (!model.getShape(structMember.getTarget()).filter(Shape::isStringShape).isPresent()) {
                errors.put(memberName, ErrorReason.BAD_TARGET);
                continue;
            }
            if (structMember.isRequired()) continue;
            errors.put(memberName, ErrorReason.NOT_REQUIRED);
        }
        if (!errors.isEmpty()) {
            this.validateErrors(shape, trait, reference, implicit, errors).ifPresent(events::add);
        }
        return events;
    }

    private Map<String, String> resolveIds(ReferencesTrait.Reference reference, ResourceShape target) {
        return !reference.getIds().isEmpty() ? reference.getIds() : target.getIdentifiers().keySet().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    private void validateExplicitIds(ReferencesTrait.Reference reference, StructureShape shape, ReferencesTrait trait, ResourceShape target, Map<String, String> resolvedIds, List<ValidationEvent> events) {
        if (resolvedIds.size() != target.getIdentifiers().size()) {
            events.add(this.wrongNumberOfIdentifiers(shape, trait, reference, target.getIdentifiers().keySet()));
        }
        HashSet<String> providedKeys = new HashSet<String>(resolvedIds.keySet());
        providedKeys.removeAll(target.getIdentifiers().keySet());
        if (!providedKeys.isEmpty()) {
            events.add(this.extraneousIdentifiers(shape, trait, reference, target, providedKeys));
        }
    }

    private ValidationEvent wrongNumberOfIdentifiers(Shape shape, ReferencesTrait trait, ReferencesTrait.Reference reference, Collection<String> expectedNames) {
        String prefix = expectedNames.size() < reference.getIds().size() ? "Too many identifiers" : "Not enough identifiers";
        return this.error(shape, trait, String.format("%s were provided in the `ids` properties of %s. Expected %d identifiers(s), but found %d. This resource requires bindings for the following identifiers: [%s].", prefix, reference, expectedNames.size(), reference.getIds().size(), ValidationUtils.tickedList(expectedNames)));
    }

    private ValidationEvent extraneousIdentifiers(Shape shape, ReferencesTrait trait, ReferencesTrait.Reference reference, ResourceShape resource, Collection<String> extraneousKeys) {
        return this.error(shape, trait, String.format("`references` trait %s contains extraneous resource identifier bindings, [%s], that are not actually identifier names of the resource, `%s`. This resource has the following identifier names: [%s]", reference, ValidationUtils.tickedList(extraneousKeys), reference.getResource(), ValidationUtils.tickedList(resource.getIdentifiers().keySet())));
    }

    private Optional<ValidationEvent> validateErrors(StructureShape shape, ReferencesTrait trait, ReferencesTrait.Reference reference, boolean implicit, Map<String, ErrorReason> errors) {
        ArrayList messages = new ArrayList();
        errors.forEach((name, reason) -> {
            switch (reason) {
                case NOT_FOUND: {
                    if (implicit) {
                        messages.add(String.format("implicit binding of `%s` is not part of the structure (set \"rel\" to \"collection\" to create a collection binding)", name));
                        break;
                    }
                    messages.add(String.format("`%s` refers to a member that is not part of the structure", name));
                    break;
                }
                case BAD_TARGET: {
                    messages.add(String.format("`%s` refers to a member that does not target a string shape", name));
                    break;
                }
            }
        });
        if (messages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(shape, trait, String.format("`references` trait %s is invalid for the following reasons: %s", reference, messages.stream().sorted().collect(Collectors.joining("; ")))));
    }

    private static enum ErrorReason {
        BAD_TARGET,
        NOT_FOUND,
        NOT_REQUIRED;

    }
}

