/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;

public final class LineValidationEventFormatter
implements ValidationEventFormatter {
    @Override
    public String format(ValidationEvent event) {
        String message = event.getMessage();
        String reason = event.getSuppressionReason().orElse(null);
        if (reason != null) {
            message = message + " (" + reason + ")";
        }
        return String.format("[%s] %s: %s | %s %s:%s:%s", new Object[]{event.getSeverity(), event.getShapeId().map(ShapeId::toString).orElse("-"), message, event.getEventId(), event.getSourceLocation().getFilename(), event.getSourceLocation().getLine(), event.getSourceLocation().getColumn()});
    }
}

