/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class ShapeId
implements ToShapeId,
Comparable<ShapeId> {
    private static final ShapeIdFactory FACTORY = new ShapeIdFactory(1024);
    private final String namespace;
    private final String name;
    private final String member;
    private final String absoluteName;
    private int hash;

    private ShapeId(String absoluteName, String namespace, String name, String member) {
        this.namespace = namespace;
        this.name = name;
        this.member = member;
        this.absoluteName = absoluteName;
    }

    private ShapeId(String namespace, String name, String member) {
        this(ShapeId.buildAbsoluteIdFromParts(namespace, name, member), namespace, name, member);
    }

    public static ShapeId from(String id) {
        return FACTORY.create(id);
    }

    public static boolean isValidNamespace(CharSequence namespace) {
        if (namespace == null) {
            return false;
        }
        if (namespace.equals("smithy.api")) {
            return true;
        }
        boolean start = true;
        for (int position = 0; position < namespace.length(); ++position) {
            char c = namespace.charAt(position);
            if (start) {
                start = false;
                if (ShapeId.isValidIdentifierStart(c)) continue;
                return false;
            }
            if (c == '.') {
                start = true;
                continue;
            }
            if (ShapeId.isValidIdentifierAfterStart(c)) continue;
            return false;
        }
        return !start;
    }

    public static boolean isValidIdentifier(CharSequence identifier) {
        if (identifier == null || identifier.length() == 0) {
            return false;
        }
        if (!ShapeId.isValidIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (ShapeId.isValidIdentifierAfterStart(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIdentifierStart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean isValidIdentifierAfterStart(char c) {
        return ShapeId.isValidIdentifierStart(c) || c >= '0' && c <= '9';
    }

    public static ShapeId fromParts(String namespace, String name, String member) {
        String idFromParts = ShapeId.buildAbsoluteIdFromParts(namespace, name, member);
        ShapeId.validateParts(idFromParts, namespace, name, member);
        return new ShapeId(idFromParts, namespace, name, member);
    }

    private static void validateParts(String absoluteId, String namespace, String name, String member) {
        if (!ShapeId.isValidNamespace(namespace) || !ShapeId.isValidIdentifier(name) || member != null && !ShapeId.isValidIdentifier(member)) {
            throw new ShapeIdSyntaxException("Invalid shape ID: " + absoluteId);
        }
    }

    private static String buildAbsoluteIdFromParts(String namespace, String name, String member) {
        if (member != null) {
            return namespace + '#' + name + '$' + member;
        }
        return namespace + '#' + name;
    }

    public static ShapeId fromParts(String namespace, String name) {
        return ShapeId.fromParts(namespace, name, null);
    }

    public static ShapeId fromRelative(String namespace, String relativeName) {
        Objects.requireNonNull(namespace, "Shape ID namespace must not be null");
        Objects.requireNonNull(relativeName, "Shape ID relative name must not be null");
        if (relativeName.contains("#")) {
            throw new ShapeIdSyntaxException("Relative shape ID must not contain a namespace: " + relativeName);
        }
        return ShapeId.from(namespace + "#" + relativeName);
    }

    public static ShapeId fromOptionalNamespace(String defaultNamespace, String shapeName) {
        Objects.requireNonNull(shapeName, "Shape name must not be null");
        if (defaultNamespace == null || shapeName.contains("#")) {
            return ShapeId.from(shapeName);
        }
        return ShapeId.fromRelative(defaultNamespace, shapeName);
    }

    public ShapeId withMember(String member) {
        if (!ShapeId.isValidIdentifier(member)) {
            throw new ShapeIdSyntaxException("Invalid shape ID member: " + member);
        }
        return new ShapeId(this.namespace, this.name, member);
    }

    @Override
    public ShapeId toShapeId() {
        return this;
    }

    @Override
    public int compareTo(ShapeId other) {
        int outcome = this.toString().compareToIgnoreCase(other.toString());
        if (outcome == 0) {
            return this.toString().compareTo(other.toString());
        }
        return outcome;
    }

    public ShapeId withoutMember() {
        return new ShapeId(this.namespace, this.name, null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getMember() {
        return Optional.ofNullable(this.member);
    }

    public String asRelativeReference() {
        return this.member == null ? this.name : this.name + "$" + this.member;
    }

    public ShapeId withNamespace(String namespace) {
        if (this.namespace.equals(namespace)) {
            return this;
        }
        if (!ShapeId.isValidNamespace(namespace)) {
            throw new ShapeIdSyntaxException("Invalid shape ID: " + namespace);
        }
        return new ShapeId(namespace, this.name, this.member);
    }

    public String toString() {
        return this.absoluteName;
    }

    public boolean equals(Object other) {
        return other instanceof ShapeId && other.toString().equals(this.toString());
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = 17 + 31 * this.namespace.hashCode() * 31 + this.name.hashCode() * 17 + Objects.hashCode(this.member);
        }
        return h;
    }

    private static final class ShapeIdFactory {
        private final int maxSize;
        private final Queue<String> priorityQueue = new ConcurrentLinkedQueue<String>();
        private final Queue<String> deprioritizedQueue = new ConcurrentLinkedQueue<String>();
        private final ConcurrentMap<String, ShapeId> map;

        ShapeIdFactory(int maxSize) {
            this.maxSize = maxSize;
            this.map = new ConcurrentHashMap<String, ShapeId>(maxSize);
        }

        ShapeId create(String key) {
            ShapeId value = (ShapeId)this.map.get(key);
            if (value != null) {
                return value;
            }
            value = this.buildShapeId(key);
            if (this.map.put(key, value) == null) {
                this.offer(key, value);
                this.evict();
            }
            return value;
        }

        private ShapeId buildShapeId(String absoluteShapeId) {
            String name;
            int namespacePosition = absoluteShapeId.indexOf(35);
            if (namespacePosition <= 0 || namespacePosition == absoluteShapeId.length() - 1) {
                throw new ShapeIdSyntaxException("Invalid shape ID: " + absoluteShapeId);
            }
            String namespace = absoluteShapeId.substring(0, namespacePosition);
            String memberName = null;
            int memberPosition = absoluteShapeId.indexOf(36);
            if (memberPosition == -1) {
                name = absoluteShapeId.substring(namespacePosition + 1);
            } else {
                if (memberPosition < namespacePosition) {
                    throw new ShapeIdSyntaxException("Invalid shape ID: " + absoluteShapeId);
                }
                name = absoluteShapeId.substring(namespacePosition + 1, memberPosition);
                memberName = absoluteShapeId.substring(memberPosition + 1);
            }
            ShapeId.validateParts(absoluteShapeId, namespace, name, memberName);
            return new ShapeId(absoluteShapeId, namespace, name, memberName);
        }

        private void offer(String key, ShapeId value) {
            if (value.getNamespace().equals("smithy.api")) {
                this.priorityQueue.offer(key);
            } else {
                this.deprioritizedQueue.offer(key);
            }
        }

        private void evict() {
            String item;
            while (this.map.size() > this.maxSize && (item = this.poll()) != null && this.map.remove(item) != null) {
            }
        }

        private String poll() {
            String item = this.deprioritizedQueue.poll();
            return item != null ? item : this.priorityQueue.poll();
        }
    }
}

