/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public class ServiceValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(topDownIndex, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape shape) {
        Map<String, List<ShapeId>> duplicateOperationNames;
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Map<String, List<ShapeId>> duplicateResourceNames = ValidationUtils.findDuplicateShapeNames(topDownIndex.getContainedResources(shape.getId()));
        if (!duplicateResourceNames.isEmpty()) {
            events.add(this.conflictingNames(shape, "resources", duplicateResourceNames));
        }
        if (!(duplicateOperationNames = ValidationUtils.findDuplicateShapeNames(topDownIndex.getContainedOperations(shape))).isEmpty()) {
            events.add(this.conflictingNames(shape, "operations", duplicateOperationNames));
        }
        return events;
    }

    private ValidationEvent conflictingNames(ServiceShape shape, String descriptor, Map<String, List<ShapeId>> dupes) {
        return this.error(shape, String.format("All %s contained within a service hierarchy must have case-insensitively unique names regardless of their namespaces. The following %s were found in this service to have conflicting names: %s", descriptor, descriptor, dupes));
    }
}

