/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.List;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;
import software.amazon.smithy.utils.ListUtils;

abstract class FilteredPlugin<S extends Shape, N extends Node>
implements NodeValidatorPlugin {
    private final Class<S> shapeClass;
    private final Class<N> nodeClass;

    FilteredPlugin(Class<S> shapeClass, Class<N> nodeClass) {
        this.shapeClass = shapeClass;
        this.nodeClass = nodeClass;
    }

    @Override
    public final List<String> apply(Shape shape, Node node, ShapeIndex index) {
        if (this.shapeClass.isInstance(shape) && this.nodeClass.isInstance(node)) {
            return this.check(shape, node, index);
        }
        return ListUtils.of();
    }

    abstract List<String> check(S var1, N var2, ShapeIndex var3);
}

