/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.OptionalUtils;

public final class AuthIndex
implements KnowledgeIndex {
    private final Model model;

    public AuthIndex(Model model) {
        this.model = model;
    }

    public List<String> getDefaultServiceSchemes(ToShapeId service) {
        return this.model.getShape(service.toShapeId()).flatMap(serviceShape -> OptionalUtils.or(serviceShape.getTrait(AuthTrait.class).map(StringListTrait::getValues), () -> serviceShape.getTrait(ProtocolsTrait.class).map(ProtocolsTrait::getAllAuthSchemes).map(ListUtils::copyOf))).orElse(ListUtils.of());
    }

    public List<String> getOperationSchemes(ToShapeId service, ToShapeId operation) {
        return this.model.getShape(operation.toShapeId()).map(shape -> shape.getTrait(AuthTrait.class).map(StringListTrait::getValues).orElseGet(() -> this.getDefaultServiceSchemes(service))).orElse(ListUtils.of());
    }

    public List<String> getOperationSchemes(ToShapeId service, ToShapeId operation, String protocolName) {
        List<String> protocolSchemes = this.model.getShape(service.toShapeId()).flatMap(serviceShape -> serviceShape.getTrait(ProtocolsTrait.class)).flatMap(protocolsTrait -> protocolsTrait.getProtocol(protocolName)).map(Protocol::getAuth).orElse(ListUtils.of());
        List<String> schemes = this.getOperationSchemes(service, operation);
        return schemes.isEmpty() ? protocolSchemes : AuthIndex.intersection(schemes, protocolSchemes);
    }

    private static List<String> intersection(List<String> left, List<String> right) {
        ArrayList<String> leftCopy = new ArrayList<String>(left);
        if (left.contains("none") && !right.contains("none")) {
            ArrayList<String> copiedRight = new ArrayList<String>(right);
            copiedRight.add("none");
            leftCopy.retainAll(copiedRight);
        } else {
            leftCopy.retainAll(right);
        }
        return leftCopy;
    }
}

