/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ExamplesTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ExamplesTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(OperationShape.class).flatMap(shape -> Trait.flatMapStream(shape, ExamplesTrait.class)).flatMap(pair -> this.validateExamples(model, (OperationShape)pair.getLeft(), (ExamplesTrait)pair.getRight()).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateExamples(Model model, OperationShape shape, ExamplesTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        List<ExamplesTrait.Example> examples = trait.getExamples();
        for (ExamplesTrait.Example example : examples) {
            if (shape.getInput().isPresent()) {
                model.getShape(shape.getInput().get()).ifPresent(input -> {
                    NodeValidationVisitor validator = this.createVisitor("input", example.getInput(), model, shape, example);
                    events.addAll((Collection)input.accept(validator));
                });
            } else if (!example.getInput().isEmpty()) {
                events.add(this.error(shape, trait, String.format("Input parameters provided for operation with no input structure members: `%s`", example.getTitle())));
            }
            if (shape.getOutput().isPresent()) {
                model.getShape(shape.getOutput().get()).ifPresent(output -> {
                    NodeValidationVisitor validator = this.createVisitor("output", example.getOutput(), model, shape, example);
                    events.addAll((Collection)output.accept(validator));
                });
                continue;
            }
            if (example.getOutput().isEmpty()) continue;
            events.add(this.error(shape, trait, String.format("Output parameters provided for operation with no output structure members: `%s`", example.getTitle())));
        }
        return events;
    }

    private NodeValidationVisitor createVisitor(String name, ObjectNode value, Model model, Shape shape, ExamplesTrait.Example example) {
        return NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value(value).startingContext("Example " + name + " of `" + example.getTitle() + "`").eventId(this.getName()).build();
    }
}

