/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.Collections;
import java.util.List;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;
import software.amazon.smithy.model.validation.node.TimestampFormatPlugin;
import software.amazon.smithy.utils.ListUtils;

public enum TimestampValidationStrategy implements NodeValidatorPlugin
{
    FORMAT{

        @Override
        public List<String> apply(Shape shape, Node value, ShapeIndex index) {
            return new TimestampFormatPlugin().apply(shape, value, index);
        }
    }
    ,
    EPOCH_SECONDS{

        @Override
        public List<String> apply(Shape shape, Node value, ShapeIndex index) {
            if (TimestampValidationStrategy.isTimestampMember(index, shape) && !value.isNumberNode()) {
                return ListUtils.of((Object)("Invalid " + (Object)((Object)value.getType()) + " value provided for timestamp, `" + shape.getId() + "`. Expected a number that contains epoch seconds with optional millisecond precision"));
            }
            return Collections.emptyList();
        }
    };


    private static boolean isTimestampMember(ShapeIndex model, Shape shape) {
        return shape.asMemberShape().map(MemberShape::getTarget).flatMap(model::getShape).filter(Shape::isTimestampShape).isPresent();
    }
}

