/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.net.MalformedURLException;
import java.net.URL;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;

public final class ExternalDocumentationTrait
extends StringTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#externalDocumentation");

    public ExternalDocumentationTrait(String value, SourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
        ExternalDocumentationTrait.validateUrl(value, sourceLocation);
    }

    public ExternalDocumentationTrait(String value) {
        this(value, SourceLocation.NONE);
    }

    private static String validateUrl(String url, SourceLocation location) {
        try {
            new URL(url);
            return url;
        }
        catch (MalformedURLException e) {
            throw new SourceException("externalDocumentation must be a valid URL. Found " + url, location);
        }
    }

    public static final class Provider
    extends StringTrait.Provider<ExternalDocumentationTrait> {
        public Provider() {
            super(ID, ExternalDocumentationTrait::new);
        }
    }
}

