/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.function.Function;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;

public abstract class BooleanTrait
extends AbstractTrait {
    public BooleanTrait(ShapeId id, SourceLocation sourceLocation) {
        super(id, sourceLocation);
    }

    @Override
    protected final Node createNode() {
        return new BooleanNode(true, this.getSourceLocation());
    }

    public static class Provider<T extends BooleanTrait>
    extends AbstractTrait.Provider {
        private final Function<SourceLocation, T> traitFactory;

        public Provider(ShapeId id, Function<SourceLocation, T> traitFactory) {
            super(id);
            this.traitFactory = traitFactory;
        }

        public T createTrait(ShapeId id, Node value) {
            if (value.asObjectNode().isPresent() && value.asObjectNode().get().getMembers().isEmpty()) {
                return (T)((BooleanTrait)this.traitFactory.apply(value.getSourceLocation()));
            }
            BooleanNode booleanNode = value.expectBooleanNode();
            if (!booleanNode.getValue()) {
                throw new SourceException(String.format("Boolean trait `%s` expects a value of `true`, but found `false`", this.getShapeId()), value);
            }
            return (T)((BooleanTrait)this.traitFactory.apply(value.getSourceLocation()));
        }
    }
}

