/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.selector.Parser;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;

@FunctionalInterface
public interface Selector {
    public static final Selector IDENTITY = (visitor, shapes) -> shapes;

    public Set<Shape> select(NeighborProvider var1, Set<Shape> var2);

    @Deprecated
    default public Set<Shape> select(NeighborProvider neighborProvider, ShapeIndex index) {
        return this.select(neighborProvider, index.toSet());
    }

    default public Set<Shape> select(NeighborProvider neighborProvider, Model model) {
        return this.select(neighborProvider, model.toSet());
    }

    @Deprecated
    default public Set<Shape> select(ShapeIndex index) {
        return this.select(NeighborProvider.of(index), index);
    }

    default public Set<Shape> select(Model model) {
        return this.select(NeighborProvider.of(model), model);
    }

    public static Selector parse(String expression) {
        return Parser.parse(expression);
    }
}

