/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SetUtils;

final class OfSelector
implements Selector {
    private final List<Selector> selectors;

    OfSelector(List<Selector> selectors) {
        this.selectors = selectors;
    }

    @Override
    public Set<Shape> select(NeighborProvider neighborProvider, Set<Shape> shapes) {
        HashSet<Shape> result = new HashSet<Shape>();
        shapes.stream().filter(Shape::isMemberShape).forEach(shape -> this.findParent(neighborProvider, (Shape)shape).ifPresent(parent -> {
            Set parentSet = SetUtils.of((Object)parent);
            boolean anyMatch = this.selectors.stream().anyMatch(selector -> !selector.select(neighborProvider, parentSet).isEmpty());
            if (anyMatch) {
                result.add((Shape)shape);
            }
        }));
        return result;
    }

    private Optional<Shape> findParent(NeighborProvider neighborProvider, Shape shape) {
        return neighborProvider.getNeighbors(shape).stream().filter(rel -> rel.getRelationshipType() == RelationshipType.MEMBER_CONTAINER).flatMap(rel -> OptionalUtils.stream(rel.getNeighborShape())).findFirst();
    }
}

