/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.UnreferencedShapes;
import software.amazon.smithy.model.neighbor.UnreferencedTraitDefinitions;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.FilterMetadata;
import software.amazon.smithy.model.transform.FilterShapes;
import software.amazon.smithy.model.transform.FilterTraits;
import software.amazon.smithy.model.transform.MapShapes;
import software.amazon.smithy.model.transform.MapTraits;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;
import software.amazon.smithy.model.transform.RemoveShapes;
import software.amazon.smithy.model.transform.ReplaceShapes;
import software.amazon.smithy.model.transform.ScrubTraitDefinitions;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.ListUtils;

public final class ModelTransformer {
    private final List<ModelTransformerPlugin> plugins;

    private ModelTransformer(List<ModelTransformerPlugin> plugins) {
        this.plugins = ListUtils.copyOf(plugins);
    }

    public static ModelTransformer create() {
        return DefaultHolder.INSTANCE;
    }

    private static ModelTransformer createWithServiceLoader(ServiceLoader<ModelTransformerPlugin> serviceLoader) {
        ArrayList<ModelTransformerPlugin> plugins = new ArrayList<ModelTransformerPlugin>();
        serviceLoader.forEach(plugins::add);
        return ModelTransformer.createWithPlugins(plugins);
    }

    public static ModelTransformer createWithPlugins(List<ModelTransformerPlugin> plugins) {
        return new ModelTransformer(plugins);
    }

    public static ModelTransformer createWithServiceProviders(ClassLoader classLoader) {
        return ModelTransformer.createWithServiceLoader(ServiceLoader.load(ModelTransformerPlugin.class, classLoader));
    }

    public Model replaceShapes(Model model, Collection<Shape> shapes) {
        if (shapes.isEmpty()) {
            return model;
        }
        return new ReplaceShapes(shapes).transform(this, model);
    }

    public Model removeShapes(Model model, Collection<Shape> shapes) {
        if (shapes.isEmpty()) {
            return model;
        }
        return new RemoveShapes(shapes, this.plugins).transform(this, model);
    }

    public Model removeShapesIf(Model model, Predicate<Shape> predicate) {
        return this.filterShapes(model, FunctionalUtils.not(predicate));
    }

    public Model filterShapes(Model model, Predicate<Shape> predicate) {
        return new FilterShapes(predicate).transform(this, model);
    }

    public Model filterTraits(Model model, BiPredicate<Shape, Trait> predicate) {
        return new FilterTraits(predicate).transform(this, model);
    }

    public Model removeTraitsIf(Model model, BiPredicate<Shape, Trait> predicate) {
        return this.filterTraits(model, predicate.negate());
    }

    public Model filterMetadata(Model model, BiPredicate<String, Node> predicate) {
        return new FilterMetadata(predicate).transform(model);
    }

    public Model mapTraits(Model model, BiFunction<Shape, Trait, Trait> mapper) {
        return new MapTraits(mapper).transform(this, model);
    }

    public Model mapTraits(Model model, List<BiFunction<Shape, Trait, Trait>> mappers) {
        return this.mapTraits(model, mappers.stream().reduce((a, b) -> (s, t) -> (Trait)b.apply(s, (Trait)a.apply(s, t))).orElse((s, t) -> t));
    }

    public Model mapShapes(Model model, Function<Shape, Shape> mapper) {
        return new MapShapes(mapper).transform(this, model);
    }

    public Model mapShapes(Model model, List<Function<Shape, Shape>> mappers) {
        return this.mapShapes(model, mappers.stream().reduce(Function::compose).orElse(Function.identity()));
    }

    public Model removeUnreferencedShapes(Model model) {
        return this.removeUnreferencedShapes(model, shape -> true);
    }

    public Model removeUnreferencedShapes(Model model, Predicate<Shape> keepFilter) {
        return this.removeShapes(model, new UnreferencedShapes(keepFilter).compute(model));
    }

    public Model removeUnreferencedTraitDefinitions(Model model) {
        return this.removeUnreferencedTraitDefinitions(model, traitDefinition -> true);
    }

    public Model removeUnreferencedTraitDefinitions(Model model, Predicate<Shape> keepFilter) {
        return this.removeShapes(model, new UnreferencedTraitDefinitions(keepFilter).compute(model));
    }

    public Model scrubTraitDefinitions(Model model) {
        return new ScrubTraitDefinitions().transform(this, model);
    }

    public ShapeIndex getNonTraitShapes(Model model) {
        ShapeIndex currentIndex = model.getShapeIndex();
        ShapeIndex.Builder indexBuilder = ShapeIndex.builder();
        this.scrubTraitDefinitions(model).getShapeIndex().shapes().map(Shape::getId).map(currentIndex::getShape).map(Optional::get).forEach(indexBuilder::addShape);
        return indexBuilder.build();
    }

    private static class DefaultHolder {
        static final ModelTransformer INSTANCE = ModelTransformer.createWithServiceProviders(ModelTransformer.class.getClassLoader());

        private DefaultHolder() {
        }
    }
}

