/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;

public abstract class StringListTrait
extends AbstractTrait {
    private final List<String> values;

    public StringListTrait(ShapeId id, List<String> values, FromSourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.values = Objects.requireNonNull(values, "values must not be null");
    }

    @Override
    protected final Node createNode() {
        return ArrayNode.fromStrings(this.values);
    }

    public final List<String> getValues() {
        return this.values;
    }

    public static class Provider<T extends StringListTrait>
    extends AbstractTrait.Provider {
        private final BiFunction<List<String>, SourceLocation, T> traitFactory;

        public Provider(ShapeId id, BiFunction<List<String>, SourceLocation, T> traitFactory) {
            super(id);
            this.traitFactory = traitFactory;
        }

        public T createTrait(ShapeId id, Node value) {
            List<String> values = Node.loadArrayOfString(id.toString(), value);
            return (T)((StringListTrait)this.traitFactory.apply(values, value.getSourceLocation()));
        }
    }

    public static abstract class Builder<TRAIT extends StringListTrait, BUILDER extends Builder>
    extends AbstractTraitBuilder<TRAIT, BUILDER> {
        private final List<String> values = new ArrayList<String>();

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public BUILDER addValue(String value) {
            this.values.add(Objects.requireNonNull(value));
            return (BUILDER)this;
        }

        public BUILDER values(Collection<String> values) {
            this.clearValues();
            this.values.addAll(values);
            return (BUILDER)this;
        }

        public BUILDER removeValue(String value) {
            this.values.remove(value);
            return (BUILDER)this;
        }

        public BUILDER clearValues() {
            this.values.clear();
            return (BUILDER)this;
        }
    }

    @FunctionalInterface
    public static interface StringListTraitConstructor<T extends StringListTrait> {
        public T create(List<String> var1, FromSourceLocation var2);
    }
}

